/*
 * Copyright (c) 2007-2008 Compuware Corporation and others.
 * All rights reserved. This program and the accompanying 
 * materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at:
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors:
 *     Compuware Corporation - initial API and implementation
 */
package org.eclipse.corona.test;

/**
 * ITestSummary - interface to test result summary
 * 
 */
public interface ITestSummary {

	public void initialize(ITestSuite testSuite, ITestResult testResult, String[] output );

	public ITestSuite getTestSuite();
	
	/**
	 * Get the name of the test suite
	 * 
	 * @return The name that identifies the test suite
	 */
	public String getName();

	/**
	 * Get the level of execution for the test suite
	 * 
	 * @return test suite's execution level
	 */
	public int getLevel();
	
	/**
	 * Get the results for the tests that were run.
	 * 
	 * @return JUnit test results
	 */
	public ITestResult getTestResult();
	
	/**
	 * Get the start time when the tests were run.
	 * 
	 * @return Start time in milliseconds
	 */
	public long getRunStartTime();
	
	/**
	 * Get the stop time when the tests were run.
	 * 
	 * @return stop time in milliseconds
	 */
	public long getRunStopTime();
	
	/**
	 * Get the system output created by the tests.
	 * 
	 * @return test system output
	 */
	public String[] getOutput();
	
	/**
	 * Format TestSummary as brief string report
	 *  
	 */
	public String toString();
	
	public void start();
	public void stop();

}
