/*
 * Copyright (c) 2007-2008 Compuware Corporation and others.
 * 
 * All rights reserved. This program and the accompanying 
 * materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at:
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors:
 *     Compuware Corporation - initial API and implementation
 */
package org.eclipse.corona.internal.diagnostic;


import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.util.Date;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import org.eclipse.corona.diagnostic.IDiagnosticData;
import org.eclipse.corona.diagnostic.IDiagnosticManager;

public class DiagCommands implements CommandProvider {

	private static String help = "---Corona Diagnostics---\n"+
	"\t diagSave - save diagnostic data components (w/ optional 'filter')\n"+
	"\t diagLoad - save diagnostic data components\n"+
	"\t diagList - list diagnostic data components\n";

	private BundleContext ctxBundle;
	
	/**
	 * Default CTOR used by Declarative Services
	 */
	public DiagCommands() {
		
	}
	
	/**
	 * Activate the service component
	 * 
	 * @param ctxComponent
	 */
	protected void activate(ComponentContext ctxComponent ) {
		this.ctxBundle = ctxComponent.getBundleContext();
	}
	
	/**
	 * @see CommandProvider#getHelp()
	 */
	public String getHelp() {
		return help;
	}

	public void _diagSave(CommandInterpreter ci) {
		ci.println("Saving Diagnostic Data...");
		
		String filter = ci.nextArgument();

		try {
			ServiceReference srvRef = this.ctxBundle.getServiceReference(IDiagnosticManager.class.getName());
			
			if (srvRef !=null) {
				IDiagnosticManager diagMgr = (IDiagnosticManager)this.ctxBundle.getService(srvRef);
				
				File diagFile = null;
				
				if ( (filter==null) || (filter.equals("")) ) {
					diagFile = diagMgr.saveData();
				}
				else {
					diagFile = diagMgr.saveData(filter);					
				}

		        ci.println("diagnostic data saved to file: "+diagFile.getAbsolutePath());
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			ci.printStackTrace(e);
		}
	}

	public void _diagLoad(CommandInterpreter ci) {
		ci.println("Load Diagnostic Data...");
		
		String name = ci.nextArgument();

		try {
			ServiceReference srvRef = this.ctxBundle.getServiceReference(IDiagnosticManager.class.getName());
			
			if (srvRef !=null) {
				IDiagnosticManager diagMgr = (IDiagnosticManager)this.ctxBundle.getService(srvRef);
				
				File diagFile = diagMgr.saveData(name);

				diagMgr.loadData(diagFile);
		        ci.println("diagnostic load from file: "+diagFile.getAbsolutePath());
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			ci.printStackTrace(e);
		}
	}

	public void _diagList(CommandInterpreter ci) { 
		try {
			ServiceReference srvRef = this.ctxBundle.getServiceReference(IDiagnosticManager.class.getName());
			
			if (srvRef !=null) {
				IDiagnosticManager diagMgr = (IDiagnosticManager)this.ctxBundle.getService(srvRef);
				
				String[] names = diagMgr.listDiagnosticData();

				for (int i = 0; i < names.length; i++) {
			        ci.println("...IDiagnosticData: "+names[i] );
				}
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			ci.printStackTrace(e);
		}
	}
}
