/*
 * Copyright (c) 2007-2008 Compuware Corporation and others.
 * 
 * All rights reserved. This program and the accompanying 
 * materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at:
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors:
 *     Compuware Corporation - initial API and implementation
 */
package org.eclipse.corona.diagnostic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

import javax.xml.parsers.ParserConfigurationException;

public interface IDiagnosticData {

	/*
	 * Define Eclipse extension point
	 */
	public static final String EXT_POINT_DIAGNOSTIC_DATA = "org.eclipse.corona.diagnostic.data";

	public static final String COMPONENT_NAME="name";
	public static final String COMPONENT_VERSION="version";
	
	public static final String TYPE_XML = "xml";
	public static final String TYPE_OBJECT = "obj";
	public static final String TYPE_TEXT = "txt";
	
	public static final String ATTR_MANIFEST_VERSION = "Manifest-Version";
	public static final String MANIFEST_VERSION = "1.0";
	
	public static final String ATTR_DIAGNOSTIC_MANIFEST_VERSION="Diagnostic-ManifestVersion";
	public static final String DIAGNOSTIC_MANIFEST_VERSION="1.0.0";
	
	public static final String ATTR_DIAGNOSTIC_VERSION="Diagnostic-Version";
	public static final String DIAGNOSTIC_VERSION="1.0.0";
	
	public static final String ATTR_DIAGNOSTIC_VENDOR="Diagnostic-Vendor";
	public static final String DIAGNOSTIC_VENDOR="Eclipse.org";

	/**
	 * The name of this diagnostic data
	 * 
	 * @return name
	 */
	public String getName();
	public void setName(String name);
	
	/**
	 * Get the type of diagnostic dump
	 * <p>
	 * The type is used to identify the contents of the
	 * diagnostic data.  It will optionally be used as the
	 * file extension of the dump file.
	 * </p>
	 * 
	 * @return diagnostic data type
	 */
	public String getType();
	
	/**
	 * The version of the diagnostic data
	 * 
	 * @return version
	 */
	public String getVersion();
	public void setVersion(String version);
	
	/**
	 * Get the properties associated with this diagnostic data
	 * @return
	 */
	public Hashtable<String, Object> getProperties();
	
	/**
	 * Capture the diagnostic data
	 */
	public void capture();
	
	/**
	 * Save the diagnostic data to a file.
	 * 
	 * @param outStream file output stream to write to
	 * @throws IOException
	 */
	public void save(OutputStream outStream) throws IOException;
	
	/**
	 * Load the diagnostic data from a file.
	 * 
	 * @param inStream file input stream to read from
	 * @throws IOException
	 * @throws ParserConfigurationException 
	 */
	public void load(InputStream inStream) throws DiagnosticException;
	
}
