/*
 * Copyright (c) 2007-2008 Compuware Corporation and others.
 * 
 * All rights reserved. This program and the accompanying 
 * materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at:
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors:
 *     Compuware Corporation - initial API and implementation
 */
package org.eclipse.corona.diagnostic.data;

import java.io.Serializable;

import org.osgi.service.event.Event;

public class EventData implements Serializable {

	private static final long serialVersionUID = 1L;

	private long timestamp;
	private Event event;
	
	public EventData(Event event) {
		this.timestamp = System.currentTimeMillis();
		this.event = event;
	}
	
	public long getTimestamp() {
		return this.timestamp;
	}
	
	public Event getEvent() {
		return this.event;
	}
}
