/*
 * Copyright (c) 2007-20089 Compuware Corporation and others.
 * 
 * All rights reserved. This program and the accompanying 
 * materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at:
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors:
 *     Compuware Corporation - initial API and implementation
 */
package org.eclipse.corona;

import java.io.File;
import java.util.concurrent.ThreadFactory;

import org.eclipse.equinox.app.IApplication;

/**
 * A service component defined as an OSGi Service Application
 * 
 */
public interface IServiceApplication extends IApplication, ThreadFactory {

	/**
	 * Name of the server application
	 * 
	 * @return
	 */
	public String getName();
	
	/**
	 * Get the working directory for this application.
	 * 
	 * @return File object set to the server application's root directory, 
	 * or <b>null</b> if no working directory was defined.
	 */
	public File getWorkingDirectory();

	/**
	 * Get the ThreadGroup for this component server application.
	 * 
	 * @return ThreadGroup used for server's threads
	 */
	public ThreadGroup getThreadGroup();
}
