/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.equinox.internal.p2.touchpoint.natives.actions.CleanupcopyAction;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;

public class CopyAction
extends ProvisioningAction {
    public static final String ID = "cp";

    public IStatus execute(Map parameters) {
        return CopyAction.copy(parameters, true);
    }

    public static IStatus copy(Map parameters, boolean restoreable) {
        IBackupStore backupStore;
        String target = (String)parameters.get("target");
        IBackupStore iBackupStore = backupStore = restoreable ? (IBackupStore)parameters.get("backup") : null;
        if (target == null) {
            return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", 0, NLS.bind((String)Messages.param_not_set, (Object)"target", (Object)ID), null);
        }
        String source = (String)parameters.get("source");
        if (source == null) {
            return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", 0, NLS.bind((String)Messages.param_not_set, (Object)"source", (Object)ID), null);
        }
        String overwrite = (String)parameters.get("overwrite");
        Profile profile = (Profile)parameters.get("profile");
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        String originalSource = source;
        if (source.equals("@artifact")) {
            IFileArtifactRepository downloadCache;
            if (iu.getArtifacts() == null || iu.getArtifacts().length == 0) {
                return Status.OK_STATUS;
            }
            IArtifactKey artifactKey = iu.getArtifacts()[0];
            try {
                downloadCache = Util.getDownloadCacheRepo();
            }
            catch (ProvisionException e) {
                return e.getStatus();
            }
            File fileLocation = downloadCache.getArtifactFile(artifactKey);
            if (fileLocation == null || !fileLocation.exists()) {
                return Util.createError(NLS.bind((String)Messages.artifact_not_available, (Object)artifactKey));
            }
            source = fileLocation.getAbsolutePath();
        }
        File sourceFile = new File(source);
        File targetFile = new File(target);
        File[] copiedFiles = null;
        try {
            copiedFiles = CopyAction.mergeCopy(sourceFile, targetFile, Boolean.valueOf(overwrite), backupStore);
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", 0, NLS.bind((String)Messages.copy_failed, (Object)sourceFile.getPath()), (Throwable)e);
        }
        StringBuffer copiedFileNameBuffer = new StringBuffer();
        int i = 0;
        while (i < copiedFiles.length) {
            copiedFileNameBuffer.append(copiedFiles[i].getAbsolutePath()).append("|");
            ++i;
        }
        profile.setInstallableUnitProperty(iu, "copied|" + originalSource + "|" + target, copiedFileNameBuffer.toString());
        return Status.OK_STATUS;
    }

    public IStatus undo(Map parameters) {
        return CleanupcopyAction.cleanupcopy(parameters, false);
    }

    private static File[] mergeCopy(File source, File target, boolean overwrite, IBackupStore backupStore) throws IOException {
        ArrayList copiedFiles = new ArrayList();
        CopyAction.xcopy(copiedFiles, source, target, overwrite, backupStore);
        return copiedFiles.toArray(new File[copiedFiles.size()]);
    }

    private static void xcopy(ArrayList copiedFiles, File source, File target, boolean overwrite, IBackupStore backupStore) throws IOException {
        if (!source.exists()) {
            throw new IOException("Source: " + source + "does not exists");
        }
        if (source.isDirectory()) {
            if (target.exists() && target.isFile()) {
                if (!overwrite) {
                    throw new IOException("Target: " + target + " already exists");
                }
                if (backupStore != null) {
                    backupStore.backup(target);
                } else {
                    target.delete();
                }
            }
            if (!target.exists()) {
                target.mkdirs();
            }
            copiedFiles.add(target);
            File[] children = source.listFiles();
            if (children == null) {
                throw new IOException("Error while retrieving children of directory: " + source);
            }
            int i = 0;
            while (i < children.length) {
                CopyAction.xcopy(copiedFiles, children[i], new File(target, children[i].getName()), overwrite, backupStore);
                ++i;
            }
            return;
        }
        if (target.exists() && !overwrite) {
            throw new IOException("Target: " + target + " already exists");
        }
        if (!target.getParentFile().exists() && !target.getParentFile().mkdirs()) {
            throw new IOException("Target: Path " + target.getParent() + " could not be created");
        }
        try {
            Util.copyStream(new FileInputStream(source), true, new FileOutputStream(target), true);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("Error while copying:" + source.getAbsolutePath());
        }
        copiedFiles.add(target);
    }
}

