/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona;

import java.io.File;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.eclipse.corona.IServiceApplication;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractServiceApplication
implements IServiceApplication {
    private Logger logger = Logger.getLogger((String)AbstractServiceApplication.class.getName());
    private static final String WORKING_DIR = "working.dir";
    protected String name;
    private String[] args;
    private Properties properties = new Properties();
    protected File workingDir;
    private ThreadGroup threadGroup;
    private ServiceRegistration srvRegistration;
    private BundleContext ctxBundle;

    public Object start(BundleContext ctxBundle, IApplicationContext ctxApplication, String name) throws Exception {
        this.ctxBundle = ctxBundle;
        Integer status = IApplication.EXIT_OK;
        this.setName(name);
        Map mapArgs = ctxApplication.getArguments();
        this.args = mapArgs != null ? (String[])mapArgs.get("application.args") : new String[0];
        this.initProperties();
        this.initialize();
        this.srvRegistration = ctxBundle.registerService(IServiceApplication.class.getName(), (Object)this, (Dictionary)this.properties);
        return status;
    }

    public void stop() {
        this.srvRegistration.unregister();
    }

    private void initProperties() {
        int i = 0;
        while (i < this.args.length) {
            String arg = this.args[i];
            if (arg.contains("=")) {
                try {
                    StringTokenizer strtok = new StringTokenizer(arg, "=");
                    String name = strtok.nextToken();
                    String value = strtok.nextToken();
                    this.properties.setProperty(name, value);
                }
                catch (Exception exception) {
                    this.logger.warn((Object)("invalid argument property: " + arg));
                }
            }
            ++i;
        }
    }

    protected void initialize() {
        this.threadGroup = new ThreadGroup(this.getName());
        this.initWorkingDir();
    }

    protected void initWorkingDir() {
        String name = this.getProperty(WORKING_DIR);
        if (name == null) {
            this.logger.info((Object)"defaulting application working.dir to workspace");
            String instanceArea = System.getProperty("osgi.instance.area.default");
            if (instanceArea != null) {
                File workspace = new File(instanceArea);
                File workingDir = new File(workspace, this.getName());
                name = workingDir.getAbsolutePath();
            } else {
                this.logger.warn((Object)"workspace is NOT defined.  unable to set application's working.dir");
            }
        }
        if (name != null) {
            this.workingDir = new File(name);
            if (!this.workingDir.exists()) {
                this.workingDir.mkdirs();
            }
        }
    }

    protected String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    protected void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public String[] getArguments() {
        return this.args;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.properties.setProperty("name", name);
    }

    public File getWorkingDirectory() {
        if (this.workingDir == null) {
            this.logger.warn((Object)"component server application not properly configured...");
            this.logger.warn((Object)"...application working.dir is NOT defined, attempting to using 'java.io.tmpdir'");
            File dirTemp = new File(System.getProperty("java.io.tmpdir"));
            this.workingDir = new File(dirTemp, this.getName());
            if (!this.workingDir.exists()) {
                this.workingDir.mkdirs();
            }
        }
        return this.workingDir;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public Thread newThread(Runnable run) {
        Thread thread = new Thread(this.threadGroup, run);
        return thread;
    }

    protected void startBundles(String[] bundleNames) {
        Bundle[] bundles = this.ctxBundle.getBundles();
        int i = 0;
        while (i < bundleNames.length) {
            String bundleName = bundleNames[i];
            boolean found = false;
            int j = 0;
            while (j < bundles.length) {
                String symbolicName = bundles[j].getSymbolicName();
                if (symbolicName.equals(bundleName)) {
                    found = true;
                    try {
                        if (bundles[j].getState() == 4) {
                            this.logger.info((Object)("application.startBundles(): " + symbolicName));
                            bundles[j].start();
                        }
                    }
                    catch (BundleException e) {
                        this.logger.warn((Object)("application.startBundles(): " + symbolicName), (Throwable)e);
                    }
                }
                ++j;
            }
            if (!found) {
                this.logger.warn((Object)("Cound NOT start bundle - not found: " + bundleName));
            }
            ++i;
        }
    }

    protected void stopBundles(String[] bundleNames) {
        Bundle[] bundles = this.ctxBundle.getBundles();
        int i = 0;
        while (i < bundleNames.length) {
            int j = 0;
            while (j < bundles.length) {
                String symbolicName = bundles[j].getSymbolicName();
                if (symbolicName.equals(bundleNames[i])) {
                    try {
                        if (bundles[j].getState() == 32) {
                            this.logger.info((Object)("application.stopBundles(): " + symbolicName));
                            bundles[j].stop();
                        }
                    }
                    catch (BundleException e) {
                        this.logger.warn((Object)("application.stopBundles(): " + symbolicName), (Throwable)e);
                    }
                }
                ++j;
            }
            ++i;
        }
    }
}

