/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.internal;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class Activator
extends Plugin {
    private Logger logger = Logger.getLogger((String)Activator.class.getName());
    private static Activator plugin;
    private BundleContext ctxBundle;

    public Activator() {
        String console = System.getProperty("osgi.console");
        if (console != null) {
            BasicConfigurator.configure();
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.ctxBundle = context;
        this.logger.info((Object)"Corona has started!");
    }

    public void stop(BundleContext context) throws Exception {
        this.logger.info((Object)"Corona has stopped!");
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public BundleContext getBundleContext() {
        return this.ctxBundle;
    }

    public void startBundle(String bundleName) {
        Bundle[] bundles = this.ctxBundle.getBundles();
        boolean found = false;
        int j = 0;
        while (j < bundles.length) {
            String symbolicName = bundles[j].getSymbolicName();
            if (symbolicName.equals(bundleName)) {
                found = true;
                try {
                    if (bundles[j].getState() == 4) {
                        this.logger.info((Object)("application.startBundles(): " + symbolicName));
                        bundles[j].start();
                    }
                }
                catch (BundleException e) {
                    this.logger.warn((Object)("application.startBundles(): " + symbolicName), (Throwable)e);
                }
            }
            ++j;
        }
        if (!found) {
            this.logger.warn((Object)("Cound NOT start bundle - not found: " + bundleName));
        }
    }
}

