/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.test;

import java.util.List;
import org.eclipse.corona.test.ITestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ITestResult {
    public static final int UNKNOWN = -1;
    public static final int SUCCESS = 0;
    public static final int FAILURES = 1;
    public static final int ERRORS = 2;
    public static final int EXECUTING = 4;

    public long getRunCount();

    public long getFailureCount();

    public long getRunTime();

    public long getIgnoreCount();

    public long getErrorCount();

    public TestSuiteExecutionStatus getCTFTestSuiteExecutionStatus();

    public void setCTFTestSuiteExecutionStatus(TestSuiteExecutionStatus var1);

    public ITestSuite getTestSuite();

    public void addTestSuiteExecutionStatus(TestSuiteExecutionStatus var1);

    public List<TestSuiteExecutionStatus> getTestSuiteExecutionStatuses();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TestSuiteExecutionStatus {
        UNKNOWN(-1, "unknown"),
        SUCCESS(0, "success"),
        FAILURES(1, "failures"),
        ERRORS(2, "errors"),
        EXECUTING(4, "executing");

        private final int value;
        private final String label;

        private TestSuiteExecutionStatus(int n2, String string2) {
            this.value = n2;
            this.label = string2;
        }

        public int value() {
            return this.value;
        }

        public String label() {
            return this.label;
        }

        public static TestSuiteExecutionStatus getTestSuiteExecutionStatus(int n) {
            switch (n) {
                case -1: {
                    return UNKNOWN;
                }
                case 0: {
                    return SUCCESS;
                }
                case 1: {
                    return FAILURES;
                }
                case 2: {
                    return ERRORS;
                }
                case 4: {
                    return EXECUTING;
                }
            }
            return UNKNOWN;
        }
    }
}

