/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.test;

import java.util.Date;
import org.eclipse.corona.test.ITestResult;
import org.eclipse.corona.test.ITestSuite;
import org.eclipse.corona.test.ITestSummary;

public class TestSummary
implements ITestSummary {
    private long tsRunStart;
    private long tsRunStop;
    private String[] output;
    private ITestSuite testSuite;
    private ITestResult testResult;

    public TestSummary() {
        this.start();
    }

    public void initialize(ITestSuite iTestSuite, ITestResult iTestResult, String[] stringArray) {
        this.testSuite = iTestSuite;
        this.output = stringArray;
        this.testResult = iTestResult;
    }

    public void start() {
        this.tsRunStart = System.currentTimeMillis();
    }

    public void stop() {
        this.tsRunStop = System.currentTimeMillis();
    }

    public long getRunStartTime() {
        return this.tsRunStart;
    }

    public long getRunStopTime() {
        return this.tsRunStop;
    }

    public String[] getOutput() {
        return this.output;
    }

    public String getName() {
        return this.testSuite.getName();
    }

    public int getLevel() {
        return this.testSuite.getLevel();
    }

    public ITestSuite getTestSuite() {
        return this.testSuite;
    }

    public ITestResult getTestResult() {
        return this.testResult;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\tCTF Test Suite: " + this.getName() + "\n");
        stringBuffer.append("\n");
        stringBuffer.append("\tTime\n");
        long l = this.getRunStartTime();
        long l2 = this.getRunStopTime();
        double d = ((double)l2 - (double)l) / 1000.0;
        stringBuffer.append("\t\t   Start: " + new Date(l) + "\n");
        stringBuffer.append("\t\t    Stop: " + new Date(l2) + "\n");
        stringBuffer.append("\t\t Elapsed: " + d + " (seconds)\n");
        ITestResult iTestResult = this.getTestResult();
        stringBuffer.append("\tCounts\n");
        stringBuffer.append("\t\t Tests count : " + iTestResult.getRunCount() + "\n");
        stringBuffer.append("\t\t Success     : " + (iTestResult.getRunCount() - iTestResult.getErrorCount() - iTestResult.getFailureCount()) + "\n");
        stringBuffer.append("\t\t Failures    : " + iTestResult.getFailureCount() + "\n");
        stringBuffer.append("\t\t Errors      : " + iTestResult.getErrorCount() + "\n");
        stringBuffer.append("\tResult: " + iTestResult.getCTFTestSuiteExecutionStatus().label() + "\n");
        stringBuffer.append(TestSummary.getTestMergedOutput(this.getOutput()));
        return stringBuffer.toString();
    }

    public static String getTestMergedOutput(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray != null) {
            stringBuffer.append("\tTest System Output...\n");
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append("\t" + stringArray[n] + "\n");
                ++n;
            }
        }
        return stringBuffer.toString();
    }
}

