/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.internal.diagnostic;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.corona.diagnostic.DiagnosticException;
import org.eclipse.corona.diagnostic.IDiagnosticData;
import org.eclipse.corona.diagnostic.IDiagnosticManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.w3c.dom.Document;

public class DiagnosticManager
implements IDiagnosticManager {
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_NAME = "name";
    private Logger logger = Logger.getLogger((String)DiagnosticManager.class.getName());
    private BundleContext ctxBundle;
    private Document docDiag;
    private StringBuffer manifestEntries = new StringBuffer();

    protected void activate(ComponentContext componentContext) {
        this.ctxBundle = componentContext.getBundleContext();
    }

    public String[] listDiagnosticData() {
        IConfigurationElement[] iConfigurationElementArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.corona.diagnostic.data");
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
                String string = iConfigurationElement.getAttribute(ATTR_NAME);
                String string2 = iConfigurationElement.getAttribute(ATTR_VERSION);
                arrayList.add(String.valueOf(string) + " (" + string2 + ")");
                ++n2;
            }
        }
        try {
            iConfigurationElementArray = this.ctxBundle.getServiceReferences(IDiagnosticData.class.getName(), null);
            if (iConfigurationElementArray != null) {
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    IDiagnosticData iDiagnosticData = (IDiagnosticData)this.ctxBundle.getService((ServiceReference)iConfigurationElementArray[n]);
                    arrayList.add(iDiagnosticData.getName());
                    this.ctxBundle.ungetService((ServiceReference)iConfigurationElementArray[n]);
                    ++n;
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public File saveData() throws DiagnosticException {
        return this.saveData("(name=*)");
    }

    public File saveData(String string) throws DiagnosticException {
        FileOutputStream fileOutputStream;
        String string2 = "corona_" + Long.toString(System.currentTimeMillis()) + ".dmp";
        File file = this.ctxBundle.getDataFile(string2);
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            DiagnosticException diagnosticException = new DiagnosticException("Unable to process diagnostic dump file");
            diagnosticException.initCause(fileNotFoundException);
            throw diagnosticException;
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        Filter filter = null;
        try {
            filter = this.ctxBundle.createFilter(string);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            DiagnosticException diagnosticException = new DiagnosticException("Invalid IDiagnostData filter");
            throw diagnosticException;
        }
        this.saveDataExtensions(filter, zipOutputStream);
        this.saveDataServices(string, zipOutputStream);
        this.createManifest(zipOutputStream);
        try {
            zipOutputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            DiagnosticException diagnosticException = new DiagnosticException("Unable to process diagnostic dump file");
            diagnosticException.initCause(iOException);
            throw diagnosticException;
        }
        return file;
    }

    private void saveDataExtensions(Filter filter, ZipOutputStream zipOutputStream) {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.corona.diagnostic.data");
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
                String string = iConfigurationElement.getAttribute(ATTR_NAME);
                String string2 = iConfigurationElement.getAttribute(ATTR_VERSION);
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put(ATTR_NAME, string);
                hashtable.put(ATTR_VERSION, string2);
                boolean bl = false;
                if (filter.match(hashtable)) {
                    bl = true;
                }
                if (bl) {
                    try {
                        IDiagnosticData iDiagnosticData = (IDiagnosticData)iConfigurationElement.createExecutableExtension("class");
                        iDiagnosticData.setName(string);
                        iDiagnosticData.setVersion(string2);
                        this.dumpDiagnosticData(iDiagnosticData, zipOutputStream);
                        this.addManifestEntry(String.valueOf(string) + ".version=" + string2);
                    }
                    catch (CoreException coreException) {
                        this.logger.error((Object)"Unable to create diag data extension", (Throwable)coreException);
                    }
                    catch (DiagnosticException diagnosticException) {
                        this.logger.error((Object)"Unable to capture diag data: ", (Throwable)diagnosticException);
                    }
                }
                ++n2;
            }
        }
    }

    private void saveDataServices(String string, ZipOutputStream zipOutputStream) throws DiagnosticException {
        ServiceReference[] serviceReferenceArray;
        try {
            serviceReferenceArray = this.ctxBundle.getServiceReferences(IDiagnosticData.class.getName(), string);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            DiagnosticException diagnosticException = new DiagnosticException("Unable to get list of IDiagnosticData component services");
            diagnosticException.initCause(invalidSyntaxException);
            throw diagnosticException;
        }
        int n = 0;
        while (serviceReferenceArray != null && n < serviceReferenceArray.length) {
            ServiceReference serviceReference = serviceReferenceArray[n];
            IDiagnosticData iDiagnosticData = (IDiagnosticData)this.ctxBundle.getService(serviceReference);
            this.dumpDiagnosticData(iDiagnosticData, zipOutputStream);
            String[] stringArray = serviceReference.getPropertyKeys();
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string2 = stringArray[n2];
                if (!(string2.equals("service.id") || string2.equals("component.id") || string2.equals("objectClass"))) {
                    Object object;
                    Object object2 = serviceReference.getProperty(string2);
                    String string3 = null;
                    if (object2 instanceof String[]) {
                        object = (String[])object2;
                        string3 = object[0];
                        int n3 = 1;
                        while (n3 < ((String[])object).length) {
                            string3 = String.valueOf(string3) + "," + object[n3];
                            ++n3;
                        }
                    } else {
                        string3 = object2.toString();
                    }
                    object = String.valueOf(iDiagnosticData.getName()) + "." + string2;
                    this.addManifestEntry(String.valueOf(object) + ": " + string3);
                }
                ++n2;
            }
            ++n;
        }
    }

    private void addManifestEntry(String string) {
        this.manifestEntries.append(String.valueOf(string) + "\n");
    }

    private void createManifest(ZipOutputStream zipOutputStream) throws DiagnosticException {
        ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
        try {
            zipOutputStream.putNextEntry(zipEntry);
        }
        catch (IOException iOException) {
            DiagnosticException diagnosticException = new DiagnosticException("Unable to process diagnostic dump file");
            diagnosticException.initCause(iOException);
            throw diagnosticException;
        }
        PrintStream printStream = new PrintStream(zipOutputStream);
        printStream.println("Manifest-Version: 1.0");
        printStream.println("Diagnostic-ManifestVersion: 1.0.0");
        printStream.println("Diagnostic-Version: 1.0.0");
        printStream.println("Diagnostic-Vendor: Eclipse.org");
        printStream.println(this.manifestEntries.toString());
        try {
            zipOutputStream.closeEntry();
        }
        catch (IOException iOException) {
            DiagnosticException diagnosticException = new DiagnosticException("Unable to process diagnostic dump file");
            diagnosticException.initCause(iOException);
            throw diagnosticException;
        }
    }

    private void dumpDiagnosticData(IDiagnosticData iDiagnosticData, ZipOutputStream zipOutputStream) throws DiagnosticException {
        iDiagnosticData.capture();
        ZipEntry zipEntry = new ZipEntry(String.valueOf(iDiagnosticData.getName()) + "." + iDiagnosticData.getType());
        try {
            zipOutputStream.putNextEntry(zipEntry);
            iDiagnosticData.save(zipOutputStream);
            zipOutputStream.closeEntry();
        }
        catch (IOException iOException) {
            DiagnosticException diagnosticException = new DiagnosticException("Unable to process diagnostic dump file");
            diagnosticException.initCause(iOException);
            throw diagnosticException;
        }
    }

    public IDiagnosticData[] loadData(File file) throws DiagnosticException {
        IDiagnosticData[] iDiagnosticDataArray;
        ArrayList<IDiagnosticData> arrayList;
        block5: {
            arrayList = new ArrayList<IDiagnosticData>();
            try {
                IConfigurationElement[] iConfigurationElementArray;
                iDiagnosticDataArray = new ZipFile(file);
                IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.corona.diagnostic.data");
                if (iExtensionPoint == null) break block5;
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
                    String string = iConfigurationElement.getAttribute(ATTR_NAME);
                    String string2 = iConfigurationElement.getAttribute(ATTR_VERSION);
                    try {
                        IDiagnosticData iDiagnosticData = (IDiagnosticData)iConfigurationElement.createExecutableExtension("class");
                        iDiagnosticData.setName(string);
                        iDiagnosticData.setVersion(string2);
                        String string3 = String.valueOf(iDiagnosticData.getName()) + "." + iDiagnosticData.getType();
                        ZipEntry zipEntry = iDiagnosticDataArray.getEntry(string3);
                        InputStream inputStream = iDiagnosticDataArray.getInputStream(zipEntry);
                        iDiagnosticData.load(inputStream);
                        arrayList.add(iDiagnosticData);
                    }
                    catch (Throwable throwable) {
                        this.logger.error((Object)("Unable to load diag data for: " + string), throwable);
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                DiagnosticException diagnosticException = new DiagnosticException("Unable to load diagnostic data.");
                diagnosticException.initCause(throwable);
                this.logger.error((Object)diagnosticException.getLocalizedMessage(), (Throwable)diagnosticException);
                throw diagnosticException;
            }
        }
        iDiagnosticDataArray = arrayList.toArray(new IDiagnosticData[arrayList.size()]);
        return iDiagnosticDataArray;
    }
}

