/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.diag.data.system;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.corona.diagnostic.AbstractDiagnosticData;
import org.eclipse.corona.diagnostic.DiagnosticException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CoronaSystemDiagnostic
extends AbstractDiagnosticData
implements Serializable {
    private static final long serialVersionUID = 1L;

    public void capture() {
        Object object;
        super.capture();
        Properties properties = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string = System.getProperty((String)object);
            this.addProperty((String)object, string);
        }
        object = Runtime.getRuntime();
        this.addProperty("runtime.max.memory", new Long(((Runtime)object).maxMemory()));
        this.addProperty("runtime.free.memory", new Long(((Runtime)object).freeMemory()));
        this.addProperty("runtime.total.memory", new Long(((Runtime)object).totalMemory()));
        this.addProperty("runtime.available.processors", new Integer(((Runtime)object).availableProcessors()));
    }

    private void createXML() throws ParserConfigurationException {
        super.initXmlDocument();
        Element element = super.createElementPropertyList();
        this.rootDiag.appendChild(element);
    }

    public void load(InputStream inputStream) throws DiagnosticException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.docDiag = documentBuilder.parse(inputStream);
            Node node = this.docDiag.getFirstChild();
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                if (node2.getNodeName().equals("PropertyList")) {
                    NodeList nodeList2 = node2.getChildNodes();
                    int n2 = 0;
                    while (n2 < nodeList2.getLength()) {
                        Node node3 = nodeList2.item(n2);
                        if (node3.getNodeName().equals("Property")) {
                            NamedNodeMap namedNodeMap = node3.getAttributes();
                            Node node4 = namedNodeMap.getNamedItem("name");
                            String string = node4.getNodeValue();
                            String string2 = node2.getTextContent();
                            this.addProperty(string, string2);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            DiagnosticException diagnosticException = new DiagnosticException("Unable to process diagnostic data");
            diagnosticException.initCause(throwable);
            throw diagnosticException;
        }
    }

    public void save(OutputStream outputStream) throws IOException {
        try {
            this.createXML();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IOException iOException = new IOException(parserConfigurationException.getMessage());
            iOException.initCause(parserConfigurationException);
            throw iOException;
        }
        super.save(outputStream);
        this.cleanUp();
    }

    public String getType() {
        return "xml";
    }
}

