/*
 * Copyright (c) 2007-2008 Compuware Corporation and others.
 * 
 * All rights reserved. This program and the accompanying 
 * materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at:
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors:
 *     Compuware Corporation - initial API and implementation
 */
package org.eclipse.corona.diagnostic;

import java.io.File;


/**
 * The DiagnosticManager interacts with all of the diagnotic agents.
 * 
 * @author doflynn
 */
public interface IDiagnosticManager {

	public static final String DEFAULT_FILTER="(name=*)";
	
	public static final String ERR_INVALID_FILTER="Invalid IDiagnostData filter";
	
	/**
	 * Save the diagnostic data to a File
	 * 
	 * Note: all diagnostic data collection extensions will be 
	 * saved to the dump file.
	 * 
	 * @return path where dump data file was saved
	 * @throws DiagnosticException
	 */
	public File saveData() throws DiagnosticException;

	/**
	 * Save the diagnostic data to a File
	 * 
	 * @param filter is an OSGi filter expression (LDAP) used to select
	 * the diagnostic data collection extensions.
	 * 
	 * @return path where dump data file was saved
	 * @throws DiagnosticException
	 */
	public File saveData( String filter ) throws DiagnosticException;
	
	/**
	 * Load the diagnostic data from a file
	 * 
	 * @param file
	 * @throws DiagnosticException
	 */
	public IDiagnosticData[] loadData( File file ) throws DiagnosticException;
	
	/**
	 * List diagnostic data dump components
	 * 
	 * @return
	 */
	public String[] listDiagnosticData();
	
}
