/*
 * Copyright (c) 2007-2008 Compuware Corporation and others.
 * 
 * All rights reserved. This program and the accompanying 
 * materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at:
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors:
 *     Compuware Corporation - initial API and implementation
 */
package org.eclipse.corona.test;

import java.util.ArrayList;
import java.util.Date;

public class TestMergedOutput {

	private final ArrayList<String> listOutput = new ArrayList<String>();

	public TestMergedOutput() {
		Date now = new Date();
		
		listOutput.add("Merged Ouput: "+now.toString()+" ("+now.getTime()+")\n");
	}
	
	synchronized public void addOutput(String type, String string) {
		long now = System.currentTimeMillis();

		String output = new String("["+Long.toString(now)+" "+type+"] "+string);
		listOutput.add(output);
	}

	public String[] getOutput() {
		return (String[]) listOutput.toArray(new String[listOutput.size()]);
	}

}
