/*
 * Copyright (c) 2007-2008 Compuware Corporation and others.
 * 
 * All rights reserved. This program and the accompanying 
 * materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at:
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors:
 *     Compuware Corporation - initial API and implementation
 */
package org.eclipse.corona.test;

import org.eclipse.corona.test.ITestResult.TestSuiteExecutionStatus;

public class TestResultsBuilder {

	public static ITestResult createTestResult( ITestSuite testSuite ) {

		TestResult testResult = new TestResult(testSuite);
		
		Throwable xception = testSuite.getException();
		if ( xception != null ) {
			TestFailure testFailure = new TestFailure();
			testFailure.message = "Invalid Test Suite: "+ testSuite.getName();
			testFailure.description = "Unable to instantiate TestSuite class";
			testFailure.setTrace( xception );
			testResult.addTestSuiteExecutionStatus(TestSuiteExecutionStatus.ERRORS);
			testResult.setCTFTestSuiteExecutionStatus(TestSuiteExecutionStatus.ERRORS);
		}		
		
		return testResult;
	}
}
