/*
 * Copyright (c) 2007-2008 Compuware Corporation and others.
 * 
 * All rights reserved. This program and the accompanying 
 * materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at:
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors:
 *     Compuware Corporation - initial API and implementation
 */
package org.eclipse.corona.test;


/**
 * Corona TestSuite interface
 * 
 * The Corona test framework uses test suites to group
 * a set of unit tests.
 */
public interface ITestSuite extends Comparable<ITestSuite>{

	/*
	 * Define Eclipse extension point
	 */
	public static final String EXT_POINT = "org.eclipse.corona.test.suite";

	public static final String PROPERTY_CLASS = "class";

	/*
	 * The test.name is used to identify the name of test suite
	 */
	public static final String PROPERTY_NAME = "name";
	public static final String DEFAULT_NAME = "UnknownTestSuite";
	
	/*
	 * The test.level is used to order the execution of test suites
	 */
	public static final String PROPERTY_LEVEL = "level";
	public static final String DEFAULT_LEVEL = "5";

	public static final String JUNIT_4 = "junit4";
	public static final String JUNIT_3_8 = "junit3_8";

	/*
	 * The test.runner is used to specify the type of test runner to use
	 */
	public static final String PROPERTY_RUNNER = "runner";
	public static final String DEFAULT_RUNNER = JUNIT_4;

	/**
	 * Check if the test suite is valid or not.
	 * 
	 * @return
	 */
	public boolean isValid();
	
	/**
	 * List all of the test case classes that belong
	 * to this test suite.
	 * 
	 * @return list of test case objects
	 */
	public Object[] listTestCases();
	
	/**
	 * Get the name of the test suite
	 * 
	 * @return The name that identifies the test suite
	 */
	public String getName();
	
	/**
	 * Get the level of execution for the test suite
	 * 
	 * @return test suite's execution level
	 */
	public int getLevel();

	/**
	 * Set the name of this test suite
	 * 
	 * @param name of the test suite
	 */
	public void setName(String name);
	
	/**
	 * Set the test run level for this test suite
	 * 
	 * @param level
	 */
	public void setLevel(int level);
	public void setLevel(String level);
	
	/**
	 * Set the contributor of this test suite. The contributor is the fragment
	 * or the bundle containing the test suite.
	 * 
	 * @param contributorLabel
	 */
	public void setContributorLabel(String contributorLabel);
	public String getContributorLabel();
	
	/**
	 * Set the name of test runner to use with this test suite.
	 * 
	 * @param runner
	 */
	public void setRunnerType(String type);
	public String getRunnerType();
	
	/**
	 * Get any exception that was thrown that prevented 
	 * the TestSuite from running.
	 * 
	 * @return
	 */
	public Throwable getException();
}
