/*
 * Copyright (c) 2007-2008 Compuware Corporation and others.
 * 
 * All rights reserved. This program and the accompanying 
 * materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at:
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors:
 *     Compuware Corporation - initial API and implementation
 */
package org.eclipse.corona.test;

import org.eclipse.corona.test.ITestFailure;

public class TestFailure implements ITestFailure {

	protected String message;
	protected String description;
	protected String trace;
	
	public String getMessage() {
		return this.message;
	}

	public String getTestDescription() {
		return this.description;
	}

	public String getTrace() {
		return this.trace;
	}

	public void setTrace(Throwable t) {
		StringBuffer strbuf = new StringBuffer();
		StackTraceElement[] stackTrace = t.getStackTrace();
		for (int i = 0; i < stackTrace.length; i++) {
			strbuf.append(stackTrace[i].toString());
		}
		
		trace = strbuf.toString();
	}
}
