/*
 * Copyright (c) 2007-2008 Compuware Corporation and others.
 * 
 * All rights reserved. This program and the accompanying 
 * materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at:
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors:
 *     Compuware Corporation - initial API and implementation
 */
package org.eclipse.corona.test;

import java.io.IOException;
import java.io.OutputStream;

public class TestOutput extends OutputStream {

	private String type;
	private TestMergedOutput mergedOutput;
	
	public TestOutput(String type, TestMergedOutput mergedOutput ){
		this.type = type;
		this.mergedOutput = mergedOutput;
	}
	
	@Override
	public void write(byte[] bytes) throws IOException {
		addOutput( new String(bytes) );
	}

	@Override
	public void write(byte[] bytes, int offset, int length) throws IOException {
		addOutput( new String(bytes, offset, length) );
	}

	@Override
	public void write(int arg0) throws IOException {
		write( new byte[]{(byte)arg0} );
	}

	private void addOutput(String string) {
		if ( !string.equals("\r\n") ) {
			this.mergedOutput.addOutput(type, string);					
		}
	}
}
