/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator;

import org.eclipse.equinox.p2.internal.repository.comparator.ClassFileStruct;
import org.eclipse.equinox.p2.internal.repository.comparator.ClassFormatException;
import org.eclipse.equinox.p2.internal.repository.comparator.ConstantPool;
import org.eclipse.equinox.p2.internal.repository.comparator.ConstantPoolEntry;

public class ExceptionTableEntry
extends ClassFileStruct {
    private int startPC;
    private int endPC;
    private int handlerPC;
    private int catchTypeIndex;
    private char[] catchType;

    ExceptionTableEntry(byte[] classFileBytes, ConstantPool constantPool, int offset) throws ClassFormatException {
        this.startPC = this.u2At(classFileBytes, 0, offset);
        this.endPC = this.u2At(classFileBytes, 2, offset);
        this.handlerPC = this.u2At(classFileBytes, 4, offset);
        this.catchTypeIndex = this.u2At(classFileBytes, 6, offset);
        if (this.catchTypeIndex != 0) {
            ConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.catchTypeIndex);
            if (constantPoolEntry.getKind() != 7) {
                throw new ClassFormatException(3);
            }
            this.catchType = constantPoolEntry.getClassInfoName();
        }
    }

    public int getStartPC() {
        return this.startPC;
    }

    public int getEndPC() {
        return this.endPC;
    }

    public int getHandlerPC() {
        return this.handlerPC;
    }

    public int getCatchTypeIndex() {
        return this.catchTypeIndex;
    }

    public char[] getCatchType() {
        return this.catchType;
    }
}

