/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.CapabilityQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.Query;

public class QueryableArray
implements IQueryable {
    private final List dataSet;
    private Map namedCapabilityIndex;

    public QueryableArray(IInstallableUnit[] ius) {
        this.dataSet = Arrays.asList(ius);
    }

    public Collector query(Query query, Collector collector, IProgressMonitor monitor) {
        if (query instanceof CapabilityQuery) {
            return this.queryCapability((CapabilityQuery)query, collector, monitor);
        }
        return query.perform(this.dataSet.iterator(), collector);
    }

    private Collector queryCapability(CapabilityQuery query, Collector collector, IProgressMonitor monitor) {
        this.generateNamedCapabilityIndex();
        IRequiredCapability[] requiredCapabilities = query.getRequiredCapabilities();
        Collection resultIUs = null;
        int i = 0;
        while (i < requiredCapabilities.length) {
            Collection matchingIUs = this.findMatchingIUs(requiredCapabilities[i]);
            if (matchingIUs == null) {
                return collector;
            }
            if (resultIUs == null) {
                resultIUs = matchingIUs;
            } else {
                resultIUs.retainAll(matchingIUs);
            }
            ++i;
        }
        Iterator iterator = resultIUs.iterator();
        while (iterator.hasNext()) {
            collector.accept(iterator.next());
        }
        return collector;
    }

    private Collection findMatchingIUs(IRequiredCapability requiredCapability) {
        List iuCapabilities = (List)this.namedCapabilityIndex.get(requiredCapability.getName());
        if (iuCapabilities == null) {
            return null;
        }
        HashSet<IInstallableUnit> matchingIUs = new HashSet<IInstallableUnit>();
        Iterator iterator = iuCapabilities.iterator();
        while (iterator.hasNext()) {
            IUCapability iuCapability = (IUCapability)iterator.next();
            if (!iuCapability.capability.satisfies(requiredCapability)) continue;
            matchingIUs.add(iuCapability.iu);
        }
        return matchingIUs;
    }

    private void generateNamedCapabilityIndex() {
        if (this.namedCapabilityIndex != null) {
            return;
        }
        this.namedCapabilityIndex = new HashMap();
        Iterator iterator = this.dataSet.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator.next();
            IProvidedCapability[] providedCapabilities = iu.getProvidedCapabilities();
            int i = 0;
            while (i < providedCapabilities.length) {
                String name = providedCapabilities[i].getName();
                ArrayList<IUCapability> iuCapabilities = (ArrayList<IUCapability>)this.namedCapabilityIndex.get(name);
                if (iuCapabilities == null) {
                    iuCapabilities = new ArrayList<IUCapability>(5);
                    this.namedCapabilityIndex.put(name, iuCapabilities);
                }
                iuCapabilities.add(new IUCapability(iu, providedCapabilities[i]));
                ++i;
            }
        }
    }

    static class IUCapability {
        final IInstallableUnit iu;
        final IProvidedCapability capability;

        public IUCapability(IInstallableUnit iu, IProvidedCapability capability) {
            this.iu = iu;
            this.capability = capability;
        }
    }
}

