@echo off
rem ************************************************************
rem *                 Eclipse Corona Project
rem * 
rem * MS-DOS batch script to perform Corona utility functions
rem ************************************************************
setlocal
cls
echo Eclipse Corona Project: Eclipse Server-Side Runtime Platform

rem ************************************************************
rem * figure out which utility funciton is being requested
rem ************************************************************
set cmd=%1
shift
if "%cmd%"=="run" goto cmdRun
if "%cmd%"=="install" goto cmdInstall
goto help

rem ************************************************************
rem * run the Eclipse Server-Side Runtime Platform
rem ************************************************************
:cmdRun
eclipses -clean -console
goto :EOF


rem ************************************************************
rem * Install a P2 IU
rem ************************************************************
:cmdInstall
if "%1"=="" goto errInstallArgs
set p2.repo=%1

if "%2"=="" goto errInstallArgs
set p2.iu=%2

rem * set default arguments
call :setVar p2.dest %CD% %3 %3
call :setVar p2.profile _SELF_ Corona %3

call :p2Install

goto :EOF

rem ************************************************************
rem * set an environment variable
rem * %1 = the variable to set
rem * %2 = the default value
rem * %3 = the value to set if %4 is defined
rem * %4 = the test condition
rem ************************************************************
:setVar
set %1=%2
if not "%4"=="" set %1=%3
goto :EOF

rem ************************************************************
rem * run the eclipse p2 installer
rem ************************************************************
:p2Install

set p2.app=-application org.eclipse.equinox.p2.director.app.application

set p2.args=-consoleLog
set p2.args=%p2.args% -flavor corona
set p2.args=%p2.args% -installIU %p2.iu%
set p2.args=%p2.args% -profile %p2.profile%
set p2.args=%p2.args% -profileProperties org.eclipse.update.install.features=true
set p2.args=%p2.args% -metadataRepository %p2.repo%
set p2.args=%p2.args% -artifactRepository %p2.repo%
set p2.args=%p2.args% -destination file:/%p2.dest%
set p2.args=%p2.args% -bundlepool file:/%p2.dest%
set p2.args=%p2.args% -roaming

set vmargs=-Declipse.p2.data.area=%p2.dest%\p2

call :setLauncher

java %vmargs% -jar %launcher% -console %p2.app% %p2.args%

goto :EOF


rem ************************************************************
rem * set the eclipse equinox launcher
rem ************************************************************
:setLauncher
for %%f in (plugins\org.eclipse.equinox.launcher_*.jar) do set launcher=%%f
if "%launcher%" == "" goto errLauncher
goto :EOF

rem ************************************************************
rem * Help
rem ************************************************************
:help
echo usage: corona  ^<command^> [options]
echo commands:
echo    run     - run the Eclipse Server-Side Runtime Platform
echo    install - install IU via P2
goto :EOF

rem ************************************************************
rem * ERROR - invalid installation arguments 
rem ************************************************************
:errInstallArgs
echo ERROR: invalid installation arguments
echo syntax: corona install ^<p2.repo^> ^<p2.iu^> [p2.dest] 
echo    p2.repo - p2 repository url
echo    p2.iu   - p2 installation unit it
echo    p2.dest - p2 destination 
goto :EOF

rem ************************************************************
rem * ERROR - invalid eclipse equinox launcher 
rem ************************************************************
errLauncher:
echo ERROR - unable to identify org.eclipse.equinox.launcher
goto :EOF
