/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.test;

import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.eclipse.corona.AbstractServiceApplication;
import org.eclipse.corona.IApplicationManager;
import org.eclipse.corona.internal.test.Activator;
import org.eclipse.corona.test.ITestManager;
import org.eclipse.corona.test.ITestSuite;
import org.eclipse.corona.test.ITestSummary;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;

public class Application
extends AbstractServiceApplication
implements EventHandler {
    private Logger logger = Logger.getLogger(Application.class);
    private transient IApplicationContext ctxApplication;
    private transient BundleContext ctxBundle;
    private transient boolean stopRequest = false;
    private boolean consoleDisplay = false;
    public static final Integer TEST_OK = EXIT_OK;
    public static final Integer TEST_ERR_TEST_MANAGER = new Integer(-200);
    public static final Integer TEST_ERR_TEST_SUMMARY = new Integer(-201);
    public static final Integer TEST_ERR_DOC_BUILDER = new Integer(-202);
    public static final Integer TEST_ERR_SAVE_RESULTS = new Integer(-203);

    public Object start(IApplicationContext iApplicationContext) throws Exception {
        this.logger.info((Object)"starting test application");
        this.ctxApplication = iApplicationContext;
        this.ctxBundle = Activator.getDefault().getBundleContext();
        super.start(this.ctxBundle, iApplicationContext, Application.class.getName());
        String[] stringArray = new String[]{"event.topics", "org/eclipse/corona/test/*"};
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        hashtable.put("event.topics", stringArray);
        ServiceRegistration serviceRegistration = this.ctxBundle.registerService(EventHandler.class.getName(), (Object)this, hashtable);
        this.ctxApplication.applicationRunning();
        Integer n = new Integer(-51);
        try {
            n = this.testAll();
        }
        catch (Throwable throwable) {
            this.logger.warn((Object)"Unable to performa all test suites", throwable);
        }
        Thread.sleep(5000L);
        serviceRegistration.unregister();
        this.shutdown();
        this.logger.debug((Object)"exiting test application");
        return n;
    }

    public void stop() {
        this.logger.debug((Object)"stopping test application");
        this.stopRequest = true;
    }

    private void shutdown() {
        String string = System.getProperty("corona.test.shutdown");
        try {
            Boolean bl;
            if (string != null && (bl = new Boolean(string)).booleanValue()) {
                ServiceReference serviceReference = this.ctxBundle.getServiceReference(IApplicationManager.class.getName());
                IApplicationManager iApplicationManager = (IApplicationManager)this.ctxBundle.getService(serviceReference);
                iApplicationManager.shutdown();
                this.ctxBundle.ungetService(serviceReference);
            }
        }
        catch (Throwable throwable) {
            this.logger.error((Object)"error trying to shutdown test environment", throwable);
        }
    }

    public Integer testAll() {
        this.logger.info((Object)"Running ALL active CTF test suites...");
        ITestManager iTestManager = this.getTestManager();
        if (iTestManager == null) {
            this.logger.warn((Object)"Warning: unable to locate TestManager");
            return TEST_ERR_TEST_MANAGER;
        }
        try {
            ITestSuite[] iTestSuiteArray = iTestManager.testSuites();
            int n = 0;
            while (n < iTestSuiteArray.length) {
                ITestSummary iTestSummary = iTestManager.runTestSuite(iTestSuiteArray[n]);
                if (iTestSummary == null) {
                    this.logger.warn((Object)"Warning: no TestSummary results");
                    return TEST_ERR_TEST_SUMMARY;
                }
                this.displayTestSummary(iTestSummary);
                if (this.stopRequest) {
                    this.logger.warn((Object)"Execution of test suites has been interrupted");
                    break;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.logger.warn((Object)("ERROR: " + exception.getMessage()), (Throwable)exception);
            return TEST_ERR_TEST_MANAGER;
        }
        return TEST_OK;
    }

    private ITestManager getTestManager() {
        ServiceTracker serviceTracker = new ServiceTracker(this.ctxBundle, ITestManager.class.getName(), null);
        serviceTracker.open();
        ITestManager iTestManager = null;
        try {
            iTestManager = (ITestManager)serviceTracker.waitForService(15000L);
        }
        catch (Exception exception) {
            this.logger.warn((Object)"Unable to get ITestManager service", (Throwable)exception);
        }
        serviceTracker.close();
        return iTestManager;
    }

    private void displayTestSummary(ITestSummary iTestSummary) {
        this.logger.info((Object)iTestSummary.toString());
    }

    public void handleEvent(Event event) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Test Progress Event: ");
        String string = (String)event.getProperty("event");
        stringBuffer.append("state=" + string + " ");
        string = (String)event.getProperty("test.status");
        string = string == null ? "unknown" : string;
        stringBuffer.append("status=" + string + " ");
        ITestSuite iTestSuite = (ITestSuite)event.getProperty("test.suite");
        string = iTestSuite.getName();
        stringBuffer.append("suite=" + string + " ");
        String string2 = (String)event.getProperty("test.case");
        string = string2 == null ? "" : string2;
        stringBuffer.append("case=" + string + " ");
        this.logger.info((Object)stringBuffer.toString());
    }
}

