/*
 * Copyright (c) 2007-2008 Compuware Corporation and others.
 * 
 * All rights reserved. This program and the accompanying 
 * materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at:
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors:
 *     Compuware Corporation - initial API and implementation
 */
package org.eclipse.corona.test;

import java.io.Serializable;

import org.osgi.service.event.EventConstants;

/**
 * Corona's Test Framework publishes events to notify the environment of
 * the testing progress.
 * <p>
 * The following OSGi event constants are used:
 * <ul>
 * <li>TIMESTAMP</li>
 * <li>MESSAGE</li>
 * <li>EXCEPTION_MESSAGE</li>
 * </ul>
 * </p>
 * @author doflynn
 */
public interface ITestEvent extends Serializable, EventConstants {

	public static final String TOPIC_ROOT = "org/eclipse/corona/test";
	
	public static final String TEST_START = "test.start";
	public static final String TEST_STOP = "test.stop";
	public static final String TEST_SUITE = "test.suite";
	public static final String TEST_CASE = "test.case";
	public static final String TEST_STATUS = "test.status";
	
}
