/*
 * Copyright (c) 2007-2008 Compuware Corporation and others.
 * 
 * All rights reserved. This program and the accompanying 
 * materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at:
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors:
 *     Compuware Corporation - initial API and implementation
 */
package org.eclipse.corona.test;

/**
 * Corona Test Manager
 * 
 */
public interface ITestManager {

	/**
	 * Run <i>all</i> test suites
	 * @return 
	 */
	public ITestSummary[] runAllTestSuites() throws Exception;

	/**
	 * Run a <i>suite</i> of test cases
	 * @param testSuite
	 * @return JUnit test results
	 * @throws Exception
	 */
	public ITestSummary runTestSuite(ITestSuite testSuite) throws Exception;
	
	/**
	 * Get the list of ITestSuite's
	 * 
	 * @return
	 */
	public ITestSuite[] testSuites();
}
