/*
 * Copyright (c) 2007-2008 Compuware Corporation and others.
 * 
 * All rights reserved. This program and the accompanying 
 * materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at:
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors:
 *     Compuware Corporation - initial API and implementation
 */
package org.eclipse.corona.test;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.corona.test.ITestResult;
import org.eclipse.corona.test.ITestSuite;

/**
 * TestResult
 * <p/>
 * The results from running a CTF Test Suite.
 * 
 * @author doflynn
 */
public class TestResult implements ITestResult {

	protected TestSuiteExecutionStatus ctfTestSuiteExecutionStatus = TestSuiteExecutionStatus.UNKNOWN;
	// This contains the result of Test Suites 
	protected List<TestSuiteExecutionStatus> testSuiteExecutionStatuses;
	protected long errorCount = 0;
	protected long failureCount = 0;
	protected long ignoreCount = 0;
	protected long runCount = 0;
	protected long runTime = 0;
	private ITestSuite testSuite;
	
	public TestResult( ITestSuite testSuite) {
		this.testSuite = testSuite;
		
		testSuiteExecutionStatuses = new ArrayList<TestSuiteExecutionStatus>();
	}
	
	public long getFailureCount() {
		return this.failureCount;
	}

	public long getIgnoreCount() {
		return this.ignoreCount;
	}

	public long getRunCount() {
		return this.runCount;
	}
	
	public long getErrorCount() {
		return this.errorCount;
	}

	public long getRunTime() {
		return this.runTime;
	}

	public ITestSuite getTestSuite() {
		return this.testSuite;
	}

	public void setCTFTestSuiteExecutionStatus(TestSuiteExecutionStatus ctfTestSuiteExecutionStatus){		
		this.ctfTestSuiteExecutionStatus = ctfTestSuiteExecutionStatus;		
	}
	
	public TestSuiteExecutionStatus getCTFTestSuiteExecutionStatus(){
		return this.ctfTestSuiteExecutionStatus;
	}
	
	public void addTestSuiteExecutionStatus(TestSuiteExecutionStatus testSuiteExecutionStatus){
		testSuiteExecutionStatuses.add(testSuiteExecutionStatus);
	}
	
	public List<TestSuiteExecutionStatus> getTestSuiteExecutionStatuses(){
		return this.testSuiteExecutionStatuses;
	}
}
