/*
 * Copyright (c) 2007-2008 Compuware Corporation and others.
 * 
 * All rights reserved. This program and the accompanying 
 * materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at:
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors:
 *     Compuware Corporation - initial API and implementation
 */
package org.eclipse.corona.diagnostic.data;

import java.io.Serializable;
import java.util.Hashtable;

import org.osgi.framework.ServiceReference;

public class ServiceReferenceData implements Serializable {
	
	private static final long serialVersionUID = 1L;
	private Hashtable<String, Object> properties;

	public ServiceReferenceData(ServiceReference srvReference ) {
		this.properties = new Hashtable<String, Object>();
		
		String[] names = srvReference.getPropertyKeys();
		for (int i = 0; i < names.length; i++) {
			Object value = srvReference.getProperty(names[i]);
			addProperty(names[i], value);
		}
	}
	
	private void addProperty( String name, Object value) {
		this.properties.put(name, value);
	}

	public String getProperty(String name) {
		return (String)this.properties.get(name);
	}

}
