package org.eclipse.corona.diagnostic.data;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;

import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class BundleData implements Serializable {

	private static final long serialVersionUID = 1L;
	private Hashtable<String, Object> properties;
	private long bundleID;
	private int bundleState;
	
	public BundleData( Bundle bundle) {
		this.bundleID = bundle.getBundleId();
		this.bundleState = bundle.getState();
		this.properties = new Hashtable<String, Object>();
		
		/*
		 * save the bundle's header properties
		 */
		saveHeaderProperties(bundle);
		
		saveServiceRegistrations(bundle);
	}

	/**
	 * Save the bundle's header properties
	 * 
	 * @param bundle
	 */
	@SuppressWarnings("unchecked")
	private void saveHeaderProperties(Bundle bundle) {
		Dictionary headerProperties = bundle.getHeaders();
		Enumeration<?> enumNames = headerProperties.keys();
		while (enumNames.hasMoreElements()) {
			String name = (String) enumNames.nextElement();
			String value = (String)headerProperties.get(name);
			addProperty(name, value);
		}
	}

	private void saveServiceRegistrations(Bundle bundle) {
		ServiceReference[] srvRefernces = bundle.getRegisteredServices();
		if ( srvRefernces != null ) {
			ServiceReferenceData[] srvRegistrations = new ServiceReferenceData[srvRefernces.length];
			for (int i = 0; i < srvRegistrations.length; i++) {
				srvRegistrations[i] = new ServiceReferenceData(srvRefernces[i]);
			}
		}		
	}
	
	private void addProperty( String name, Object value) {
		this.properties.put(name, value);
	}

	public String getProperty(String name) {
		return (String)this.properties.get(name);
	}
	
	public long getBundleID() {
		return this.bundleID;
	}

	public int getBundleState() {
		return this.bundleState;
	}
}
