/*
 * Copyright (c) 2007-2008 Compuware Corporation and others.
 * 
 * All rights reserved. This program and the accompanying 
 * materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at:
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors:
 *     Compuware Corporation - initial API and implementation
 */
package org.eclipse.corona.internal;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends Plugin {

	private Logger logger = Logger.getLogger(Activator.class.getName());
	
	// The shared instance
	private static Activator plugin;
	private BundleContext ctxBundle;
	
	/**
	 * The constructor
	 */
	public Activator() {
		super();
		
		/*
		 * enable console logging
		 */
		String console = System.getProperty("osgi.console");
		if ( console != null ) {
		     // Set up a simple configuration that logs on the console.
		     BasicConfigurator.configure();
		}
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.core.runtime.Plugins#start(org.osgi.framework.BundleContext)
	 */
	@Override
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
		this.ctxBundle = context;
	
		logger.info( "Corona has started!");
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.core.runtime.Plugin#stop(org.osgi.framework.BundleContext)
	 */
	@Override
	public void stop(BundleContext context) throws Exception {
		logger.info( "Corona has stopped!");
				
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}

	public BundleContext getBundleContext() {
		return this.ctxBundle;
	}

	/**
	 * Start OSGi Bundle
	 * <p>
	 * Convenience method to allow an OSGi Application to start a set of bundles
	 * </p>
	 * 
	 * @param bundleName
	 */
	public void startBundle(String bundleName) {
		Bundle[] bundles = ctxBundle.getBundles();
		
		/*
		 * search list of all registered bundles
		 */
		boolean found = false;
		for (int j = 0; j < bundles.length; j++) {		
			String symbolicName = bundles[j].getSymbolicName();

			if ( symbolicName.equals(bundleName)) {
				// found it!
				found = true;
				
				try {
					// if the bundle is RESOLVED - start it
					if ( bundles[j].getState() == Bundle.RESOLVED ) {
						logger.info( "application.startBundles(): " + symbolicName);

						bundles[j].start();
					}
				} catch (BundleException e) {
					logger.warn( "application.startBundles(): " + symbolicName, e);
				}
			}
		}
		
		// if not found, log it
		if ( !found ) {
			logger.warn( "Cound NOT start bundle - not found: "+bundleName);
		}
	}	
}
