/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona;

import java.util.Enumeration;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.corona.CoronaException;
import org.eclipse.corona.IApplicationManager;
import org.eclipse.corona.internal.Activator;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application
implements IApplication {
    private static final String SCHEDULED_FILTER = ".schedule.filter";
    private static final String SCHEDULED_RECURRING = ".schedule.recurring";
    private static final String CORONA_APP = "corona.app.";
    private static final String EXT_POINT_STARTUP = "org.eclipse.corona.startup";
    private static final String EXT_POINT_APPLICATION = "org.eclipse.core.runtime.applications";
    private static final String OSGI_APPLICATIONS = "osgi.applications";
    private static final String OSGI_APPLICATIONS_STARTLEVEL = "osgi.applications.defaultStartLevel";
    private Logger logger = Logger.getLogger((String)Application.class.getName());
    private boolean stopRequest = false;
    private final long STOP_TIMEOUT = 5000L;
    private BundleContext ctxBundle = Activator.getDefault().getBundleContext();
    private IApplicationManager appManager;
    private ServiceTracker srvTrackerAppManager;
    private int startLevel = 5;

    public Application() {
        String temp = System.getProperty(OSGI_APPLICATIONS_STARTLEVEL);
        if (temp != null) {
            try {
                this.startLevel = Integer.parseInt(temp);
            }
            catch (Throwable throwable) {
                this.logger.warn((Object)("invalid application start level: " + temp));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object start(IApplicationContext ctxApplication) throws Exception {
        this.logger.debug((Object)"entering Application.start()");
        this.srvTrackerAppManager = new ServiceTracker(this.ctxBundle, IApplicationManager.class.getName(), null);
        this.srvTrackerAppManager.open();
        this.appManager = (IApplicationManager)this.srvTrackerAppManager.waitForService(10000L);
        if (this.appManager == null) {
            this.logger.error((Object)"unable to get IApplicationManager service");
            return new Integer(-1);
        }
        ctxApplication.applicationRunning();
        this.startBundles();
        try {
            this.startApplications();
        }
        catch (Throwable t) {
            this.logger.error((Object)"error starting Corona IServiceApplication's", t);
        }
        this.logger.info((Object)"waiting for stop() request or all applications to end");
        Application t = this;
        synchronized (t) {
            while (!this.stopRequest) {
                this.wait(5000L);
                if (this.appManager.countRunningApplications() != 0) continue;
                this.logger.info((Object)"no more running applications");
                if (this.appManager.countScheduledApplications() != 0) continue;
                this.logger.info((Object)"no more scheduled applications");
                break;
            }
        }
        try {
            this.appManager.stopAllApplications();
        }
        catch (CoronaException e) {
            this.logger.error((Object)e.getMessage());
        }
        this.srvTrackerAppManager.close();
        this.logger.debug((Object)"exiting Application.start()");
        return EXIT_OK;
    }

    private void startBundles() {
        this.logger.info((Object)"jump starting org.eclipse.corona.startup bundles");
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(EXT_POINT_STARTUP);
        if (extPoint != null) {
            IConfigurationElement[] configElements;
            TreeMap<Integer, IContributor> mapTree = new TreeMap<Integer, IContributor>();
            String defaultLevel = System.getProperty("osgi.bundles.defaultStartLevel", "5");
            IConfigurationElement[] iConfigurationElementArray = configElements = extPoint.getConfigurationElements();
            int n = configElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement cfgElement = iConfigurationElementArray[n2];
                IExtension extension = cfgElement.getDeclaringExtension();
                String attrLevel = cfgElement.getAttribute("level");
                if (attrLevel == null) {
                    attrLevel = defaultLevel;
                }
                Integer level = new Integer(attrLevel);
                IContributor contrib = extension.getContributor();
                mapTree.put(level, contrib);
                ++n2;
            }
            for (IContributor contrib : mapTree.values()) {
                try {
                    Activator.getDefault().startBundle(contrib.getName());
                }
                catch (Exception e) {
                    this.logger.error((Object)"Unable to start bundle", (Throwable)e);
                }
            }
        }
    }

    private void startApplications() {
        this.logger.debug((Object)"entering: Application.startApplications()");
        PriorityQueue<AppSyntax> appQueue = new PriorityQueue<AppSyntax>();
        this.addOsgiApplications(appQueue);
        this.addCoronaApplications(appQueue);
        AppSyntax[] osgiApplications = appQueue.toArray(new AppSyntax[appQueue.size()]);
        this.startApplicationExtensionBundle(osgiApplications);
        int i = 0;
        while (i < osgiApplications.length) {
            try {
                AppSyntax srvApp = osgiApplications[i];
                if (srvApp.getLevel() > 0) {
                    this.appManager.startApplication(srvApp.getApp());
                }
                if (srvApp.getSchedFilter() != null) {
                    this.appManager.scheduleApplication(srvApp.getId(), srvApp.getSchedFilter(), srvApp.isSchedRecurring());
                }
            }
            catch (CoronaException e) {
                this.logger.warn((Object)e.getMessage());
            }
            ++i;
        }
        this.logger.debug((Object)"exiting: Application.startApplications()");
    }

    private void addCoronaApplications(PriorityQueue<AppSyntax> appQueue) {
        this.logger.info((Object)"disovering corona service applications");
        Properties properties = System.getProperties();
        Enumeration<Object> enumKeys = properties.keys();
        while (enumKeys.hasMoreElements()) {
            String args;
            String app;
            String name = (String)enumKeys.nextElement();
            if (!name.startsWith(CORONA_APP)) continue;
            String appCmd = app = name.substring(CORONA_APP.length());
            String startLevel = properties.getProperty(name);
            if (startLevel != null) {
                appCmd = String.valueOf(appCmd) + "@" + startLevel;
            }
            if ((args = properties.getProperty(String.valueOf(app) + ".args")) != null) {
                appCmd = String.valueOf(appCmd) + "," + args;
            }
            AppSyntax appSyntax = new AppSyntax();
            appSyntax.setApp(appCmd);
            appSyntax.setSchedFilter(properties.getProperty(String.valueOf(app) + SCHEDULED_FILTER));
            appSyntax.setSchedRecurring(properties.getProperty(String.valueOf(app) + SCHEDULED_RECURRING));
            appQueue.add(appSyntax);
        }
    }

    private void addOsgiApplications(PriorityQueue<AppSyntax> appQueue) {
        String apps = System.getProperty(OSGI_APPLICATIONS);
        if (apps == null) {
            this.logger.info((Object)"'osgi.applications' property not defined");
            return;
        }
        StringTokenizer appTokenizer = new StringTokenizer(apps, ";");
        while (appTokenizer.hasMoreTokens()) {
            String app = appTokenizer.nextToken();
            AppSyntax appSyntax = new AppSyntax();
            appSyntax.setApp(app);
            appQueue.add(appSyntax);
        }
    }

    private void startApplicationExtensionBundle(AppSyntax[] osgiApplications) {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(EXT_POINT_APPLICATION);
        if (extPoint != null) {
            IConfigurationElement[] appConfigurations;
            IConfigurationElement[] iConfigurationElementArray = appConfigurations = extPoint.getConfigurationElements();
            int n = appConfigurations.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement appCfg = iConfigurationElementArray[n2];
                IExtension extension = appCfg.getDeclaringExtension();
                String extId = extension.getUniqueIdentifier();
                boolean appFound = false;
                AppSyntax[] appSyntaxArray = osgiApplications;
                int n3 = osgiApplications.length;
                int n4 = 0;
                while (n4 < n3) {
                    AppSyntax appStart = appSyntaxArray[n4];
                    if (appStart.getId().equals(extId)) {
                        appFound = true;
                        break;
                    }
                    ++n4;
                }
                if (appFound) {
                    try {
                        IContributor contrib = extension.getContributor();
                        Activator.getDefault().startBundle(contrib.getName());
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Unable to create application extenstion", (Throwable)e);
                    }
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.logger.debug((Object)"entering Application.stop()");
        this.logger.info((Object)"stopping Corona's application");
        this.stopRequest = true;
        Application application = this;
        synchronized (application) {
            this.notify();
        }
        this.logger.debug((Object)"exiting Application.stop()");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AppSyntax
    implements Comparable<AppSyntax> {
        private Logger logger = Logger.getLogger((String)AppSyntax.class.getName());
        String app;
        String id;
        int level;
        String schedFilter;
        boolean schedRecurring;

        public AppSyntax() {
            this.level = Application.this.startLevel;
        }

        public void setApp(String app) {
            StringTokenizer appTokenizer;
            this.logger.info((Object)("setting service application: " + app));
            this.app = app;
            if (app.contains("@")) {
                appTokenizer = new StringTokenizer(app, "@,");
                String appId = appTokenizer.nextToken();
                String appLevel = appTokenizer.nextToken();
                this.setLevel(appLevel);
                StringBuffer strbuf = new StringBuffer();
                while (appTokenizer.hasMoreTokens()) {
                    strbuf.append("," + appTokenizer.nextToken());
                }
                String appArgs = strbuf.toString();
                this.app = String.valueOf(appId) + appArgs;
            }
            appTokenizer = new StringTokenizer(this.app, ",");
            this.id = appTokenizer.nextToken();
        }

        public void setLevel(String strLevel) {
            try {
                this.level = Integer.parseInt(strLevel);
            }
            catch (Throwable throwable) {
                this.logger.warn((Object)("invalid application start level: " + strLevel));
            }
        }

        public int getLevel() {
            return this.level;
        }

        public String getId() {
            return this.id;
        }

        public String getApp() {
            return this.app;
        }

        @Override
        public int compareTo(AppSyntax osgiApp) {
            int result = 0;
            if (this.level < osgiApp.getLevel()) {
                result = -1;
            }
            if (this.level > osgiApp.getLevel()) {
                result = 1;
            }
            return result;
        }

        public String getSchedFilter() {
            return this.schedFilter;
        }

        public void setSchedFilter(String schedFilter) {
            this.schedFilter = schedFilter;
        }

        public boolean isSchedRecurring() {
            return this.schedRecurring;
        }

        public void setSchedRecurring(boolean schedRecurring) {
            this.schedRecurring = schedRecurring;
        }

        public void setSchedRecurring(String schedRecurring) {
            this.schedRecurring = Boolean.getBoolean(schedRecurring);
        }
    }
}

