/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.internal;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.eclipse.corona.CoronaException;
import org.eclipse.corona.IApplicationManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.application.ApplicationHandle;
import org.osgi.service.application.ScheduledApplication;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationManager
implements IApplicationManager {
    private static final String EVENT_TOPIC_APPLICATION_TIMER = "org/osgi/application/timer";
    private Logger logger = Logger.getLogger((String)ApplicationManager.class.getName());
    private BundleContext ctxBundle;
    private ServiceTracker appDescriptors;
    private ServiceTracker appHandles;
    private Filter filterRunningApp;
    private static final String FILTER_RUNNING_APP = "(!(application.state=STOPPING))";
    private Hashtable<String, ApplicationHandle> listStartedApps = new Hashtable();

    protected void activate(ComponentContext ctxComponent) throws CoronaException {
        this.logger.debug((Object)"activate ApplicationManager");
        this.ctxBundle = ctxComponent.getBundleContext();
        try {
            this.filterRunningApp = this.ctxBundle.createFilter(FILTER_RUNNING_APP);
        }
        catch (InvalidSyntaxException e) {
            String message = "Invalid filter syntax: (!(application.state=STOPPING))";
            this.logger.error((Object)message);
            CoronaException xCorona = new CoronaException(message);
            xCorona.initCause(e);
            throw xCorona;
        }
        this.appDescriptors = new ServiceTracker(this.ctxBundle, ApplicationDescriptor.class.getName(), null);
        this.appDescriptors.open();
        this.appHandles = new ServiceTracker(this.ctxBundle, ApplicationHandle.class.getName(), null);
        this.appHandles.open();
    }

    protected void deactivate(ComponentContext ctxComponent) {
        this.logger.debug((Object)"deactivate ApplicationManager");
        this.appHandles.close();
        this.appHandles = null;
        this.appDescriptors.close();
        this.appDescriptors = null;
        this.ctxBundle = null;
    }

    @Override
    public void startApplication(String app) throws CoronaException {
        this.logger.debug((Object)("starting application: " + app));
        StringTokenizer argTokenizer = new StringTokenizer(app, ",");
        String appId = argTokenizer.nextToken();
        ArrayList<String> argList = new ArrayList<String>();
        while (argTokenizer.hasMoreTokens()) {
            argList.add(argTokenizer.nextToken());
        }
        String[] args = argList.size() == 0 ? null : argList.toArray(new String[argList.size()]);
        HashMap<String, String[]> appArgs = new HashMap<String, String[]>(1);
        if (args != null) {
            appArgs.put("application.args", args);
        }
        this.startApplication(appId, appArgs);
    }

    protected void startApplication(String appId, HashMap<String, String[]> appArgs) throws CoronaException {
        this.logger.debug((Object)("starting application: " + appId));
        ServiceReference appService = this.getServiceReference(this.appDescriptors.getServiceReferences(), appId, "service.pid", false);
        if (appService == null) {
            String msg = "Unable to find application service component: " + appId;
            this.logger.warn((Object)msg);
            throw new CoronaException(msg);
        }
        ApplicationDescriptor appDesc = (ApplicationDescriptor)this.ctxBundle.getService(appService);
        try {
            try {
                ApplicationHandle handle = appDesc.launch(appArgs);
                this.listStartedApps.put(appId, handle);
            }
            catch (Throwable t) {
                String msg = "Failed to start application: " + appId;
                this.logger.warn((Object)msg, t);
                CoronaException xCorona = new CoronaException(msg);
                xCorona.initCause(t);
                throw xCorona;
            }
        }
        finally {
            this.ctxBundle.ungetService(appService);
        }
    }

    @Override
    public void stopApplication(String appId) throws CoronaException {
        this.logger.debug((Object)("Stopping aplication: " + appId));
        ApplicationHandle appStartedHandle = this.listStartedApps.get(appId);
        if (appStartedHandle == null) {
            String msg = "Cannot stop application that ApplicationManager did not start: " + appId;
            this.logger.warn((Object)msg);
            throw new CoronaException(msg);
        }
        this.listStartedApps.remove(appId);
        ApplicationHandle appRunningHandle = this.getRunningApplication(appId);
        if (appRunningHandle == null) {
            this.logger.info((Object)("Unable to stop non-running application: " + appId));
        } else if (appStartedHandle.equals(appRunningHandle)) {
            appRunningHandle.destroy();
        } else {
            this.logger.warn((Object)("Unable to stop application - different instance: " + appId));
        }
    }

    @Override
    public void stopAllApplications() throws CoronaException {
        this.logger.debug((Object)"stopping all applications");
        Enumeration<String> enumAppId = this.listStartedApps.keys();
        while (enumAppId.hasMoreElements()) {
            String appId = enumAppId.nextElement();
            this.stopApplication(appId);
        }
    }

    @Override
    public int countRunningApplications() {
        int count = 0;
        Enumeration<String> enumAppId = this.listStartedApps.keys();
        while (enumAppId.hasMoreElements()) {
            String appId = enumAppId.nextElement();
            ApplicationHandle appStartedHandle = this.listStartedApps.get(appId);
            ApplicationHandle appRunningHandle = this.getRunningApplication(appId);
            if (appRunningHandle == null || !appStartedHandle.equals(appRunningHandle)) {
                this.listStartedApps.remove(appId);
                continue;
            }
            ++count;
        }
        return count;
    }

    @Override
    public int countScheduledApplications() {
        this.logger.warn((Object)"Not Yet Implemented: countScheduledApplications()");
        return 0;
    }

    @Override
    public boolean isApplicationRunning(String appId) {
        boolean result = false;
        ApplicationHandle appStartedHandle = this.listStartedApps.get(appId);
        if (appStartedHandle != null) {
            ApplicationHandle appRunningHandle = this.getRunningApplication(appId);
            if (appRunningHandle != null || appStartedHandle.equals(appRunningHandle)) {
                result = true;
            } else {
                this.listStartedApps.remove(appId);
            }
        }
        return result;
    }

    private ApplicationHandle getRunningApplication(String appId) {
        ApplicationHandle appHandle = null;
        ServiceReference appReference = this.getServiceReference(this.appHandles.getServiceReferences(), appId, "service.pid", false);
        if (appReference == null) {
            appReference = this.getServiceReference(this.appHandles.getServiceReferences(), appId, "application.descriptor", false);
        }
        if (appReference == null) {
            this.logger.info((Object)("unable to find running application: " + appId));
        } else if (this.filterRunningApp.match(this.getProperties(appReference))) {
            try {
                appHandle = (ApplicationHandle)this.ctxBundle.getService(appReference);
            }
            finally {
                this.ctxBundle.ungetService(appReference);
            }
        }
        return appHandle;
    }

    private ServiceReference getServiceReference(ServiceReference[] srvRefs, String targetId, String idKey, boolean perfectMatch) {
        if (srvRefs == null || targetId == null) {
            return null;
        }
        ServiceReference result = null;
        boolean ambigous = false;
        int i = 0;
        while (i < srvRefs.length) {
            String id = (String)srvRefs[i].getProperty(idKey);
            if (targetId.equals(id)) {
                return srvRefs[i];
            }
            if (!perfectMatch && id.indexOf(targetId) >= 0) {
                if (result != null) {
                    ambigous = true;
                }
                result = srvRefs[i];
            }
            ++i;
        }
        return ambigous ? null : result;
    }

    public Dictionary<String, Object> getProperties(ServiceReference ref) {
        String[] keys = ref.getPropertyKeys();
        Hashtable<String, Object> props = new Hashtable<String, Object>(keys.length);
        int i = 0;
        while (i < keys.length) {
            props.put(keys[i], ref.getProperty(keys[i]));
            ++i;
        }
        return props;
    }

    @Override
    public String[] listApplications() {
        String[] apps = null;
        ServiceReference[] srvRefs = this.appDescriptors.getServiceReferences();
        if (srvRefs != null && srvRefs.length > 0) {
            apps = new String[srvRefs.length];
            int i = 0;
            while (i < srvRefs.length) {
                apps[i] = (String)srvRefs[i].getProperty("service.pid");
                ++i;
            }
        }
        return apps;
    }

    @Override
    public ScheduledApplication[] listScheduledApplications() {
        ScheduledApplication[] apps = null;
        ServiceReference[] srvRefs = null;
        try {
            srvRefs = this.ctxBundle.getAllServiceReferences(ScheduledApplication.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            this.logger.warn((Object)e);
        }
        if (srvRefs != null && srvRefs.length > 0) {
            apps = new ScheduledApplication[srvRefs.length];
            int i = 0;
            while (i < srvRefs.length) {
                apps[i] = (ScheduledApplication)this.ctxBundle.getService(srvRefs[i]);
                this.ctxBundle.ungetService(srvRefs[i]);
                ++i;
            }
        }
        return apps;
    }

    @Override
    public void shutdown() {
        this.logger.warn((Object)"shutting down Corona runtimer environment");
        try {
            Bundle sysBundle = this.ctxBundle.getBundle(0L);
            sysBundle.stop();
        }
        catch (Throwable t) {
            this.logger.error((Object)t);
        }
    }

    @Override
    public void scheduleApplication(String appId, String filter, boolean recurring) throws CoronaException {
        ServiceReference appService = this.getServiceReference(this.appDescriptors.getServiceReferences(), appId, "service.pid", false);
        if (appService == null) {
            String msg = "Unable to find application service component: " + appId;
            this.logger.warn((Object)msg);
            throw new CoronaException(msg);
        }
        ApplicationDescriptor appDesc = (ApplicationDescriptor)this.ctxBundle.getService(appService);
        ScheduledApplication[] schedApps = this.listScheduledApplications();
        int i = 0;
        while (i < schedApps.length) {
            String schedAppId = schedApps[i].getApplicationDescriptor().getApplicationId();
            if (schedAppId.equals(appId) && schedApps[i].getEventFilter().equals(filter)) {
                return;
            }
            ++i;
        }
        try {
            try {
                appDesc.schedule(null, null, EVENT_TOPIC_APPLICATION_TIMER, filter, recurring);
            }
            catch (Throwable t) {
                String msg = "Failed to schedule application: " + appId;
                this.logger.warn((Object)msg, t);
                CoronaException xCorona = new CoronaException(msg);
                xCorona.initCause(t);
                throw xCorona;
            }
        }
        finally {
            this.ctxBundle.ungetService(appService);
        }
    }
}

