/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.validation;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.internal.databinding.observable.ValidatedObservableList;
import org.eclipse.core.internal.databinding.observable.ValidatedObservableMap;
import org.eclipse.core.internal.databinding.observable.ValidatedObservableSet;
import org.eclipse.core.internal.databinding.observable.ValidatedObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;

public abstract class MultiValidator
extends ValidationStatusProvider {
    private Realm realm;
    private IObservableValue validationStatus;
    private IObservableValue unmodifiableValidationStatus;
    private WritableList targets;
    private IObservableList unmodifiableTargets;
    private IObservableList models;
    IListChangeListener targetsListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            event.diff.accept(new ListDiffVisitor(this){
                final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void handleAdd(int index, Object element) {
                    ((IObservable)element).addChangeListener(MultiValidator.access$0(1.access$0(this.this$1)));
                }

                public void handleRemove(int index, Object element) {
                    ((IObservable)element).removeChangeListener(MultiValidator.access$0(1.access$0(this.this$1)));
                }
            });
        }

        static /* synthetic */ MultiValidator access$0(1 var0) {
            return var0.MultiValidator.this;
        }
    };
    private IChangeListener dependencyListener = new IChangeListener(){

        public void handleChange(ChangeEvent event) {
            MultiValidator.this.revalidate();
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public MultiValidator() {
        this(Realm.getDefault());
    }

    public MultiValidator(Realm realm) {
        Assert.isNotNull((Object)realm, (String)"Realm cannot be null");
        this.realm = realm;
        IStatus iStatus = ValidationStatus.ok();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.runtime.IStatus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.validationStatus = new WritableValue(realm, iStatus, clazz);
        ArrayList arrayList = new ArrayList();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.databinding.observable.IObservable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.targets = new WritableList(realm, arrayList, clazz2);
        this.targets.addListChangeListener(this.targetsListener);
        this.unmodifiableTargets = Observables.unmodifiableObservableList(this.targets);
        this.models = Observables.emptyObservableList(realm);
    }

    private void checkObservable(IObservable target) {
        Assert.isNotNull((Object)target, (String)"Target observable cannot be null");
        Assert.isTrue((boolean)this.realm.equals(target.getRealm()), (String)"Target observable must be in the same realm as MultiValidator");
    }

    public IObservableValue getValidationStatus() {
        if (this.unmodifiableValidationStatus == null) {
            this.revalidate();
            this.unmodifiableValidationStatus = Observables.unmodifiableObservableValue(this.validationStatus);
        }
        return this.unmodifiableValidationStatus;
    }

    private void revalidate() {
        final IObservable[] dependencies = ObservableTracker.runAndMonitor(new Runnable(){

            public void run() {
                try {
                    IStatus status = MultiValidator.this.validate();
                    if (status == null) {
                        status = ValidationStatus.ok();
                    }
                    MultiValidator.this.validationStatus.setValue(status);
                }
                catch (RuntimeException e) {
                    MultiValidator.this.validationStatus.setValue(ValidationStatus.error(e.getMessage(), e));
                }
            }
        }, null, null);
        ObservableTracker.runAndIgnore(new Runnable(){

            public void run() {
                MultiValidator.this.targets.clear();
                MultiValidator.this.targets.addAll(Arrays.asList(dependencies));
            }
        });
    }

    protected abstract IStatus validate();

    public IObservableValue observeValidatedValue(IObservableValue target) {
        this.checkObservable(target);
        return new ValidatedObservableValue(target, this.getValidationStatus());
    }

    public IObservableList observeValidatedList(IObservableList target) {
        this.checkObservable(target);
        return new ValidatedObservableList(target, this.getValidationStatus());
    }

    public IObservableSet observeValidatedSet(IObservableSet target) {
        this.checkObservable(target);
        return new ValidatedObservableSet(target, this.getValidationStatus());
    }

    public IObservableMap observeValidatedMap(IObservableMap target) {
        this.checkObservable(target);
        return new ValidatedObservableMap(target, this.getValidationStatus());
    }

    public IObservableList getTargets() {
        return this.unmodifiableTargets;
    }

    public IObservableList getModels() {
        return this.models;
    }

    public void dispose() {
        this.targets.clear();
        this.unmodifiableValidationStatus.dispose();
        this.validationStatus.dispose();
        this.unmodifiableTargets.dispose();
        this.targets.dispose();
        this.models.dispose();
        this.realm = null;
        this.validationStatus = null;
        this.unmodifiableValidationStatus = null;
        this.targets = null;
        this.unmodifiableTargets = null;
        this.models = null;
        super.dispose();
    }

    static /* synthetic */ IChangeListener access$0(MultiValidator multiValidator) {
        return multiValidator.dependencyListener;
    }
}

