/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.corona.test.ITestManager;
import org.eclipse.corona.test.ITestSummary;
import org.eclipse.corona.test.TestSummaryDocBuilder;
import org.eclipse.corona.test.internal.Activator;
import org.eclipse.corona.util.ServiceUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.application.ApplicationHandle;
import org.osgi.util.tracker.ServiceTracker;

public class Application
implements IApplication {
    private Logger logger = Logger.getLogger(Application.class);
    private transient IApplicationContext ctxApplication;
    private transient BundleContext ctxBundle;
    private transient boolean stopRequest = false;
    private boolean consoleDisplay = false;
    public static final Integer TEST_OK = EXIT_OK;
    public static final Integer TEST_ERR_TEST_MANAGER = new Integer(-200);
    public static final Integer TEST_ERR_TEST_SUMMARY = new Integer(-201);
    public static final Integer TEST_ERR_DOC_BUILDER = new Integer(-202);
    public static final Integer TEST_ERR_SAVE_RESULTS = new Integer(-203);

    public Application() {
        String string;
        boolean bl = false;
        String string2 = System.getProperty("eclipse.commands");
        if (string2 != null && string2.contains("-console")) {
            this.consoleDisplay = true;
            bl = true;
        }
        if (!bl && (string = System.getProperty("osgi.console")) != null) {
            this.consoleDisplay = true;
            bl = true;
        }
        if (bl) {
            BasicConfigurator.configure();
            string = Logger.getRootLogger();
            string.setLevel(Level.INFO);
        }
    }

    public Object start(IApplicationContext iApplicationContext) throws Exception {
        this.logger.info((Object)"entering start()");
        this.ctxApplication = iApplicationContext;
        this.ctxBundle = Activator.getDefault().getBundleContext();
        Integer n = new Integer(-51);
        try {
            n = this.testAll();
        }
        catch (Throwable throwable) {
            this.logger.warn((Object)"Unable to performa all test suites", throwable);
        }
        boolean bl = Boolean.getBoolean("osgi.noShutdown");
        if (!bl) {
            this.shutdown();
        }
        this.logger.info((Object)"exiting start()");
        return n;
    }

    private void shutdown() {
        String string = "org.eclipse.corona.application";
        ServiceTracker serviceTracker = new ServiceTracker(this.ctxBundle, ApplicationHandle.class.getName(), null);
        serviceTracker.open();
        ServiceReference serviceReference = ServiceUtil.getServiceReference((ServiceReference[])serviceTracker.getServiceReferences(), (String)string, (String)"service.pid", (boolean)false);
        if (serviceReference == null) {
            serviceReference = ServiceUtil.getServiceReference((ServiceReference[])serviceTracker.getServiceReferences(), (String)string, (String)"application.descriptor", (boolean)false);
        }
        if (serviceReference == null) {
            this.logger.info((Object)("\"" + string + "\" does not exist, is not running or is ambigous."));
        } else {
            String string2 = (String)serviceReference.getProperty("application.state");
            if (string2.contains("starting")) {
                try {
                    ApplicationHandle applicationHandle = (ApplicationHandle)this.ctxBundle.getService(serviceReference);
                    applicationHandle.destroy();
                    this.logger.info((Object)("Stopped application instance: " + applicationHandle.getInstanceId()));
                }
                finally {
                    this.ctxBundle.ungetService(serviceReference);
                    serviceTracker.close();
                }
            } else {
                this.logger.info((Object)("Application instance is already stopping: " + serviceReference.getProperty("service.pid")));
            }
        }
    }

    public void stop() {
        this.logger.info((Object)"entering stop()");
        this.stopRequest = true;
        this.logger.info((Object)"exiting stop()");
    }

    public Integer testAll() {
        File file;
        TestSummaryDocBuilder testSummaryDocBuilder;
        Object object;
        Object[] objectArray;
        this.logger.info((Object)"Running ALL test cases...");
        ArrayList<ITestSummary> arrayList = new ArrayList<ITestSummary>();
        ITestManager iTestManager = this.getTestManager();
        if (iTestManager == null) {
            this.logger.warn((Object)"Warning: unable to locate TestManager");
            return TEST_ERR_TEST_MANAGER;
        }
        try {
            objectArray = iTestManager.testSuites();
            int n = 0;
            while (n < objectArray.length) {
                object = iTestManager.runTestSuite(objectArray[n]);
                if (object != null) {
                    arrayList.add((ITestSummary)object);
                }
                if (this.stopRequest) {
                    this.logger.warn((Object)"Execution of test suites has been interrupted");
                    break;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.logger.warn((Object)("ERROR: " + exception.getMessage()), (Throwable)exception);
            return TEST_ERR_TEST_MANAGER;
        }
        objectArray = arrayList.toArray(new ITestSummary[arrayList.size()]);
        if (objectArray == null) {
            this.logger.warn((Object)"Warning: no TestSummary results");
            return TEST_ERR_TEST_SUMMARY;
        }
        try {
            testSummaryDocBuilder = new TestSummaryDocBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.logger.warn((Object)"Unable to build XML TestSummary", (Throwable)parserConfigurationException);
            return TEST_ERR_DOC_BUILDER;
        }
        Object object2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = object2[n2];
            testSummaryDocBuilder.addTestSummary((ITestSummary)object);
            this.displayTestSummary((ITestSummary)object);
            ++n2;
        }
        object = "TestSummary_" + Long.toString(System.currentTimeMillis()) + ".xml";
        try {
            IPath iPath = Platform.getStateLocation((Bundle)Activator.getDefault().getBundle());
            object2 = iPath.toFile();
            file = new File((File)object2, (String)object);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(testSummaryDocBuilder.getDocument());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            StreamResult streamResult = new StreamResult(fileOutputStream);
            transformer.transform(dOMSource, streamResult);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            this.logger.warn((Object)exception.getMessage());
            return TEST_ERR_SAVE_RESULTS;
        }
        this.logger.info((Object)("TestSummary results: " + file.getAbsolutePath()));
        return TEST_OK;
    }

    private ITestManager getTestManager() {
        ServiceTracker serviceTracker = new ServiceTracker(this.ctxBundle, ITestManager.class.getName(), null);
        serviceTracker.open();
        ITestManager iTestManager = null;
        try {
            iTestManager = (ITestManager)serviceTracker.waitForService(15000L);
        }
        catch (Exception exception) {
            this.logger.warn((Object)"Unable to get ITestManager service", (Throwable)exception);
        }
        serviceTracker.close();
        return iTestManager;
    }

    private void displayTestSummary(ITestSummary iTestSummary) {
        this.logger.info((Object)iTestSummary.toString());
    }
}

