/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.test;

import java.util.Enumeration;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.corona.test.ITestFailure;
import org.eclipse.corona.test.ITestResult;
import org.eclipse.corona.test.ITestSummary;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class TestSummaryDocBuilder {
    private static final String VERSION_ATTRIBUTE = "version";
    private static final String VERSION_NUMBER = "1.0";
    private static final String TEST_FAILURE = "TestFailure";
    private static final String TEST_SUMMARY = "TestSummary";
    private static final String LIST_FAILURES = "ListFailures";
    private static final String TEST_FRAMEWORK = "TestFramework";
    private Document xmlDoc;

    public TestSummaryDocBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.xmlDoc = documentBuilder.newDocument();
        Element element = this.xmlDoc.createElement(TEST_FRAMEWORK);
        element.setAttribute(VERSION_ATTRIBUTE, VERSION_NUMBER);
        this.xmlDoc.appendChild(element);
        this.captureSystemProperties();
        this.captureRuntimeProperties();
    }

    private void captureSystemProperties() {
        Object object;
        Element element = this.xmlDoc.createElement("SystemProperties");
        Properties properties = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string = System.getProperty((String)object);
            this.createPropertyElement(element, (String)object, string, false);
        }
        object = this.xmlDoc.getDocumentElement();
        object.appendChild(element);
    }

    private void captureRuntimeProperties() {
        Element element = this.xmlDoc.createElement("RuntimeProperties");
        Runtime runtime = Runtime.getRuntime();
        this.createPropertyElement(element, "runtime.max.memory", new Long(runtime.maxMemory()), false);
        this.createPropertyElement(element, "runtime.free.memory", new Long(runtime.freeMemory()), false);
        this.createPropertyElement(element, "runtime.total.memory", new Long(runtime.totalMemory()), false);
        this.createPropertyElement(element, "runtime.available.processors", new Integer(runtime.availableProcessors()), false);
        Element element2 = this.xmlDoc.getDocumentElement();
        element2.appendChild(element);
    }

    public Document getDocument() {
        return this.xmlDoc;
    }

    public void addTestSummary(ITestSummary iTestSummary) {
        Element element = this.xmlDoc.createElement(TEST_SUMMARY);
        element.setAttribute("name", iTestSummary.getName());
        element.setAttribute("level", Integer.toString(iTestSummary.getLevel()));
        long l = iTestSummary.getRunStartTime();
        this.createPropertyElement(element, "time.start", new Long(l), false);
        long l2 = iTestSummary.getRunStopTime();
        this.createPropertyElement(element, "time.stop", new Long(l2), false);
        double d = ((double)l2 - (double)l) / 1000.0;
        this.createPropertyElement(element, "time.elapsed", new Double(d), false);
        ITestResult iTestResult = iTestSummary.getTestResult();
        this.createPropertyElement(element, "test.result", iTestResult.wasSuccessful() ? "pass" : "fail", false);
        this.createPropertyElement(element, "count.run", new Integer(iTestResult.getRunCount()), false);
        this.createPropertyElement(element, "count.failure", new Integer(iTestResult.getFailureCount()), false);
        this.createPropertyElement(element, "count.ignore", new Integer(iTestResult.getIgnoreCount()), false);
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = iTestSummary.getOutput();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(String.valueOf(stringArray[n]) + "\r\n");
            ++n;
        }
        this.createPropertyElement(element, "test.output", stringBuffer.toString(), true);
        if (iTestResult.getFailureCount() > 0) {
            this.addTestResultFailures(element, iTestResult.listFailures());
        }
        Element element2 = this.xmlDoc.getDocumentElement();
        element2.appendChild(element);
    }

    private void addTestResultFailures(Element element, ITestFailure[] iTestFailureArray) {
        Element element2 = this.xmlDoc.createElement(LIST_FAILURES);
        int n = 0;
        while (n < iTestFailureArray.length) {
            Element element3 = this.xmlDoc.createElement(TEST_FAILURE);
            this.createPropertyElement(element3, "failure.message", iTestFailureArray[n].getMessage(), false);
            this.createPropertyElement(element3, "failure.trace", iTestFailureArray[n].getTrace(), true);
            element2.appendChild(element3);
            ++n;
        }
        element.appendChild(element2);
    }

    protected Element createElement(String string, String string2) {
        Element element = this.xmlDoc.createElement(string);
        Text text = this.xmlDoc.createTextNode(string2.toString());
        element.appendChild(text);
        return element;
    }

    protected void createPropertyElement(Element element, String string, Object object, boolean bl) {
        if (object == null) {
            return;
        }
        Element element2 = this.xmlDoc.createElement("Property");
        element2.setAttribute("name", string);
        String string2 = "unknown";
        if (object instanceof String) {
            string2 = "string";
        } else if (object instanceof Integer) {
            string2 = "int";
        } else if (object instanceof Long) {
            string2 = "long";
        } else if (object instanceof Double) {
            string2 = "double";
        }
        element2.setAttribute("type", string2);
        Text text = bl ? this.xmlDoc.createCDATASection(object.toString()) : this.xmlDoc.createTextNode(object.toString());
        element2.appendChild(text);
        element.appendChild(element2);
    }
}

