/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.test.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.corona.test.ITestManager;
import org.eclipse.corona.test.ITestSuite;
import org.eclipse.corona.test.ITestSummary;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class TestCommands
implements CommandProvider {
    private static String help = "---Corona Test Framework---\n\t testList - list all of test suites\n\t testAll - run ALL test suites\n\t testSuite <name> - run test suite 'name'\n";
    private BundleContext ctxBundle;

    protected void activate(ComponentContext componentContext) {
        this.ctxBundle = componentContext.getBundleContext();
    }

    public String getHelp() {
        return help;
    }

    public void _testAll(CommandInterpreter commandInterpreter) {
        Object object;
        commandInterpreter.println((Object)"Running ALL test cases...");
        ITestSummary[] iTestSummaryArray = null;
        try {
            object = this.ctxBundle.getServiceReference(ITestManager.class.getName());
            if (object != null) {
                ITestManager iTestManager = (ITestManager)this.ctxBundle.getService(object);
                iTestSummaryArray = iTestManager.runAllTestSuites();
                this.ctxBundle.ungetService(object);
            } else {
                commandInterpreter.println((Object)"Warning: unable to locate TestManager service");
            }
        }
        catch (Exception exception) {
            commandInterpreter.printStackTrace((Throwable)exception);
        }
        if (iTestSummaryArray != null) {
            ITestSummary[] iTestSummaryArray2 = iTestSummaryArray;
            int n = iTestSummaryArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = iTestSummaryArray2[n2];
                this.printTestSummary(commandInterpreter, (ITestSummary)object);
                ++n2;
            }
        } else {
            commandInterpreter.println((Object)"Warning: not test summary results to report");
        }
    }

    public void _testSuite(CommandInterpreter commandInterpreter) {
        commandInterpreter.println((Object)"Running test suite...");
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println((Object)"\tERROR: test suite name not defined");
            return;
        }
        ITestSummary iTestSummary = null;
        try {
            ServiceReference serviceReference = this.ctxBundle.getServiceReference(ITestManager.class.getName());
            if (serviceReference != null) {
                ITestManager iTestManager = (ITestManager)this.ctxBundle.getService(serviceReference);
                ITestSuite[] iTestSuiteArray = iTestManager.testSuites();
                int n = 0;
                while (n < iTestSuiteArray.length) {
                    if (iTestSuiteArray[n].getName().equals(string)) {
                        iTestSummary = iTestManager.runTestSuite(iTestSuiteArray[n]);
                        break;
                    }
                    ++n;
                }
                this.ctxBundle.ungetService(serviceReference);
            } else {
                commandInterpreter.println((Object)"Warning: unable to locate TestManager service");
            }
        }
        catch (Exception exception) {
            commandInterpreter.printStackTrace((Throwable)exception);
        }
        if (iTestSummary != null) {
            this.printTestSummary(commandInterpreter, iTestSummary);
        } else {
            commandInterpreter.println((Object)"Warning: not test summary results to report");
        }
    }

    private void printTestSummary(CommandInterpreter commandInterpreter, ITestSummary iTestSummary) {
        commandInterpreter.println((Object)iTestSummary.toString());
    }

    public void _testList(CommandInterpreter commandInterpreter) throws InvalidSyntaxException, CoreException {
        commandInterpreter.println((Object)"Listing all test suites...");
        ITestSuite[] iTestSuiteArray = null;
        try {
            ServiceReference serviceReference = this.ctxBundle.getServiceReference(ITestManager.class.getName());
            if (serviceReference != null) {
                ITestManager iTestManager = (ITestManager)this.ctxBundle.getService(serviceReference);
                iTestSuiteArray = iTestManager.testSuites();
                this.ctxBundle.ungetService(serviceReference);
            }
        }
        catch (Exception exception) {
            commandInterpreter.printStackTrace((Throwable)exception);
        }
        if (iTestSuiteArray != null) {
            int n = 0;
            while (n < iTestSuiteArray.length) {
                commandInterpreter.println((Object)("\tITestSuite: " + iTestSuiteArray[n].getName()));
                commandInterpreter.println((Object)("\t\t  type: " + iTestSuiteArray[n].getRunnerType()));
                commandInterpreter.println((Object)("\t\t level: " + iTestSuiteArray[n].getLevel()));
                ++n;
            }
        }
    }
}

