/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.debug;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.dsf.debug.sourcelookup.DsfSourceLookupDirector;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunchDelegate;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.cargo.core.CargoTools;
import org.eclipse.corrosion.debug.RustGDBLaunchWrapper;
import org.eclipse.corrosion.debug.SourceLookupDirector;
import org.eclipse.corrosion.launch.RustLaunchDelegateTools;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;

public class RustDebugDelegate
extends GdbLaunchDelegate
implements ILaunchShortcut {
    public static final String BUILD_COMMAND_ATTRIBUTE = "org.eclipse.corrosionBUILD_COMMAND";

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String buildCommand = config.getAttribute(BUILD_COMMAND_ATTRIBUTE, "");
        File projectLocation = new File(config.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", ""));
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(CargoTools.getCargoCommand());
        if (buildCommand.isEmpty()) {
            buildCommand = "build";
        }
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        buildCommand = manager.performStringSubstitution(buildCommand);
        cmdLine.addAll(Arrays.asList(buildCommand.replace('\n', ' ').split(" ")));
        Process restoreProcess = DebugPlugin.exec((String[])cmdLine.toArray(new String[cmdLine.size()]), (File)projectLocation);
        String labelString = "cargo ";
        labelString = buildCommand.length() > 20 ? String.valueOf(labelString) + buildCommand.substring(0, 20) + "..." : String.valueOf(labelString) + buildCommand;
        IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)restoreProcess, (String)labelString);
        process.setAttribute(IProcess.ATTR_CMDLINE, String.join((CharSequence)" ", cmdLine));
        try {
            restoreProcess.waitFor();
        }
        catch (InterruptedException e) {
            CorrosionPlugin.logError(e);
        }
        if (restoreProcess.exitValue() != 0) {
            return;
        }
        if (!(launch instanceof RustGDBLaunchWrapper)) {
            launch = new RustGDBLaunchWrapper((ILaunch)launch);
        }
        super.launch(config, mode, launch, monitor);
    }

    public void launch(ISelection selection, String mode) {
        ILaunchConfiguration launchConfig = this.getLaunchConfiguration(mode, RustLaunchDelegateTools.firstResourceFromSelection(selection));
        RustLaunchDelegateTools.launch(launchConfig, mode);
    }

    public void launch(IEditorPart editor, String mode) {
        ILaunchConfiguration launchConfig = this.getLaunchConfiguration(mode, RustLaunchDelegateTools.resourceFromEditor(editor));
        RustLaunchDelegateTools.launch(launchConfig, mode);
    }

    protected ISourceLocator getSourceLocator(ILaunchConfiguration configuration, DsfSession session) throws CoreException {
        SourceLookupDirector locator = new SourceLookupDirector();
        String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
        if (memento == null) {
            locator.initializeDefaults(configuration);
        } else {
            locator.initializeFromMemento(memento, configuration);
        }
        return locator;
    }

    protected DsfSourceLookupDirector createDsfSourceLocator(ILaunchConfiguration configuration, DsfSession session) throws CoreException {
        DsfSourceLookupDirector sourceLookupDirector = new DsfSourceLookupDirector(session);
        sourceLookupDirector.setSourceContainers(((SourceLookupDirector)this.getSourceLocator(configuration, session)).getSourceContainers());
        return sourceLookupDirector;
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        this.setDefaultProcessFactory(configuration);
        Object launch = super.getLaunch(configuration, mode);
        if (!(launch instanceof RustGDBLaunchWrapper)) {
            launch = new RustGDBLaunchWrapper((ILaunch)launch);
        }
        launch.setAttribute("org.eclipse.dltk.debug.debugConsole", Boolean.toString(false));
        return launch;
    }

    protected IPath checkBinaryDetails(ILaunchConfiguration config) throws CoreException {
        return LaunchUtils.verifyProgramPath((ILaunchConfiguration)config, null);
    }

    private ILaunchConfiguration getLaunchConfiguration(String mode, IResource resource) {
        ILaunchConfiguration launchConfiguration = RustLaunchDelegateTools.getLaunchConfiguration(mode, resource, "org.eclipse.corrosion.debug.RustDebugDelegate");
        if (launchConfiguration instanceof ILaunchConfigurationWorkingCopy) {
            ILaunchConfigurationWorkingCopy wc = (ILaunchConfigurationWorkingCopy)launchConfiguration;
            IProject project = resource.getProject();
            wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", project.getName());
            wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", String.valueOf(project.getLocation().toString()) + "/target/debug/" + project.getName());
            wc.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", project.getLocation().toString());
            wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
            wc.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", "rust-gdb");
        }
        return launchConfiguration;
    }
}

