/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.test;

import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.cargo.core.CargoProjectTester;
import org.eclipse.corrosion.cargo.core.CargoTools;
import org.eclipse.corrosion.cargo.ui.OptionSelector;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CargoTestTab
extends AbstractLaunchConfigurationTab {
    private Text projectText;
    private Text testnameText;
    private Text optionsText;
    private Text argsText;
    private IProject project;
    private static CargoProjectTester tester = new CargoProjectTester();

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("PROJECT", this.projectText.getText());
        configuration.setAttribute("RUN_OPTIONS", this.optionsText.getText());
        configuration.setAttribute("RUN_ARGUMENTS", this.argsText.getText());
        configuration.setAttribute("TEST_NAME", this.testnameText.getText());
        this.setDirty(false);
    }

    public void createControl(Composite parent) {
        Group container = new Group(parent, 2048);
        this.setControl((Control)container);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)container);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        Label projectLabel = new Label((Composite)container, 0);
        projectLabel.setText(Messages.CargoRunTab_project);
        projectLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.projectText = new Text((Composite)container, 2048);
        this.projectText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.projectText.addModifyListener(e -> {
            this.setDirty(true);
            this.project = !this.projectText.getText().isEmpty() ? ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectText.getText()) : null;
            this.updateLaunchConfigurationDialog();
        });
        Button browseButton = new Button((Composite)container, 0);
        browseButton.setText(Messages.CargoRunTab_browse);
        browseButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        browseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ListSelectionDialog dialog = new ListSelectionDialog(browseButton.getShell(), (Object)ResourcesPlugin.getWorkspace().getRoot(), (IStructuredContentProvider)new BaseWorkbenchContentProvider(), (ILabelProvider)new WorkbenchLabelProvider(), Messages.CargoRunTab_selectProject);
            dialog.setTitle(Messages.CargoRunTab_projectSelection);
            int returnCode = dialog.open();
            Object[] results = dialog.getResult();
            if (returnCode == 0 && results.length > 0) {
                this.projectText.setText(((IProject)results[0]).getName());
                this.setDirty(true);
                this.updateLaunchConfigurationDialog();
            }
        }));
        this.createTestCommandGroup((Composite)container);
    }

    private void createTestCommandGroup(Composite container) {
        Group testCommandGroup = new Group(container, 0);
        testCommandGroup.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        testCommandGroup.setLayout((Layout)new GridLayout(4, false));
        testCommandGroup.setText("cargo test [options] [test name] [--] [arguments]");
        Label optionLabel = new Label((Composite)testCommandGroup, 0);
        optionLabel.setText(Messages.CargoRunTab_optionsColon);
        optionLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.optionsText = new Text((Composite)testCommandGroup, 2048);
        this.optionsText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.optionsText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        Button optionButton = new Button((Composite)testCommandGroup, 0);
        optionButton.setText(Messages.CargoRunTab_options);
        optionButton.setLayoutData((Object)new GridData(4, 128, false, false));
        optionButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            OptionSelector dialog = new OptionSelector(optionButton.getShell(), CargoTools.getOptions("test").stream().filter(o -> !o.getFlag().equals("--manifest-path")).collect(Collectors.toList()));
            dialog.open();
            String result = dialog.returnOptionSelection();
            if (result != null) {
                this.optionsText.append(String.valueOf(' ') + result);
                this.setDirty(true);
                this.updateLaunchConfigurationDialog();
            }
        }));
        this.createVariablesButton((Composite)testCommandGroup, this.optionsText);
        Label testnameLabel = new Label((Composite)testCommandGroup, 0);
        testnameLabel.setText(Messages.CargoTestTab_testName);
        testnameLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.testnameText = new Text((Composite)testCommandGroup, 2048);
        this.testnameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.testnameText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        new Label((Composite)testCommandGroup, 0);
        new Label((Composite)testCommandGroup, 0);
        Label testnameExplanation = new Label((Composite)testCommandGroup, 0);
        testnameExplanation.setText(Messages.CargoTestTab_testNameDescription);
        testnameExplanation.setEnabled(false);
        testnameExplanation.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        Label argsLabel = new Label((Composite)testCommandGroup, 0);
        argsLabel.setText(Messages.CargoRunTab_arguments);
        argsLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.argsText = new Text((Composite)testCommandGroup, 2048);
        this.argsText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.argsText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        this.createVariablesButton((Composite)testCommandGroup, this.argsText);
    }

    private void createVariablesButton(Composite composite, Text resultText) {
        Button variableButton = new Button(composite, 0);
        variableButton.setText(Messages.CargoRunTab_variables);
        variableButton.setLayoutData((Object)new GridData(4, 128, false, false));
        variableButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            StringVariableSelectionDialog variableSelector = new StringVariableSelectionDialog(variableButton.getShell());
            int returnCode = variableSelector.open();
            String result = variableSelector.getVariableExpression();
            if (returnCode == 0 && result != null) {
                resultText.append(result);
            }
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        }));
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("PROJECT", "");
        configuration.setAttribute("RUN_OPTIONS", "");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.projectText.setText(configuration.getAttribute("PROJECT", ""));
        }
        catch (CoreException ce) {
            this.projectText.setText("");
        }
        try {
            this.optionsText.setText(configuration.getAttribute("RUN_OPTIONS", ""));
        }
        catch (CoreException ce) {
            this.optionsText.setText("");
        }
        try {
            this.testnameText.setText(configuration.getAttribute("TEST_NAME", ""));
        }
        catch (CoreException ce) {
            this.testnameText.setText("");
        }
        try {
            this.argsText.setText(configuration.getAttribute("RUN_ARGUMENTS", ""));
        }
        catch (CoreException ce) {
            this.argsText.setText("");
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.canSave();
    }

    public boolean canSave() {
        if (this.project != null && this.project.exists() && tester.test(this.project, "isCargoProject", null, null)) {
            this.setErrorMessage(null);
            return true;
        }
        this.setErrorMessage(Messages.CargoRunTab_invalidCargoProjectName);
        return false;
    }

    public String getName() {
        return "Main";
    }
}

