/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.wizards.export;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.cargo.core.CargoTools;
import org.eclipse.corrosion.wizards.export.CargoExportWizardPage;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class CargoExportWizard
extends Wizard
implements IExportWizard {
    private CargoExportWizardPage wizardPage;

    public CargoExportWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.CargoExportWizard_title);
        Iterator selectionIterator = selection.iterator();
        IProject project = null;
        while (selectionIterator.hasNext() && project == null) {
            IResource resource = (IResource)selectionIterator.next();
            if (!resource.getProject().getFile("Cargo.toml").exists()) continue;
            project = resource.getProject();
        }
        this.wizardPage = new CargoExportWizardPage(project);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.wizardPage);
    }

    public boolean performFinish() {
        IProject project = this.wizardPage.getProject();
        String toolchain = this.wizardPage.getToolchain();
        Boolean noVerify = this.wizardPage.noVerify();
        Boolean noMetadata = this.wizardPage.noMetadata();
        Boolean allowDirty = this.wizardPage.allowDirty();
        ArrayList<String> exportCommandList = new ArrayList<String>();
        exportCommandList.add(CargoTools.getCargoCommand());
        exportCommandList.add("package");
        if (noVerify.booleanValue()) {
            exportCommandList.add("--no-verify");
        }
        if (noMetadata.booleanValue()) {
            exportCommandList.add("--no-metadata");
        }
        if (allowDirty.booleanValue()) {
            exportCommandList.add("--allow-dirty");
        }
        if (!toolchain.isEmpty()) {
            exportCommandList.add("--target");
            exportCommandList.add(toolchain);
        }
        exportCommandList.add("--manifest-path");
        exportCommandList.add(project.getFile("Cargo.toml").getLocation().toString());
        Job.create((String)"Cargo Package", monitor -> {
            block17: {
                try {
                    ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                    Launch newLaunch = new Launch(null, "run", null);
                    Process packageProcess = DebugPlugin.exec((String[])exportCommandList.toArray(new String[exportCommandList.size()]), null);
                    DebugPlugin.newProcess((ILaunch)newLaunch, (Process)packageProcess, (String)"cargo package");
                    launchManager.addLaunch((ILaunch)newLaunch);
                    try {
                        packageProcess.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (packageProcess.exitValue() == 0) {
                        project.refreshLocal(2, null);
                        break block17;
                    }
                    String errorOutput = "";
                    try {
                        Throwable throwable = null;
                        Object var9_13 = null;
                        try (BufferedReader in = new BufferedReader(new InputStreamReader(packageProcess.getErrorStream()));){
                            String errorLine;
                            while ((errorLine = in.readLine()) != null) {
                                errorOutput = String.valueOf(errorOutput) + errorLine + '\n';
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        errorOutput = Messages.CargoExportWizard_unableToGenerateLog;
                    }
                    String finalErrorOutput = errorOutput;
                    Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)this.getShell(), (String)Messages.CargoExportWizard_cannotCreateProject, (String)NLS.bind((String)Messages.CargoExportWizard_cannotCreateProject_details, (Object)String.join((CharSequence)" ", exportCommandList), (Object)finalErrorOutput)));
                }
                catch (CoreException e) {
                    Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)this.getShell(), (String)Messages.CargoExportWizard_cannotPackageProject, (String)NLS.bind((String)Messages.CargoExportWizard_commandFailed, (Object)String.join((CharSequence)" ", exportCommandList), (Object)((Object)e))));
                }
            }
        }).schedule();
        return true;
    }
}

