/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfigurationRegistry;
import org.eclipse.tm4e.languageconfiguration.internal.supports.AutoClosingPair;
import org.eclipse.tm4e.languageconfiguration.internal.supports.EnterAction;
import org.eclipse.tm4e.languageconfiguration.internal.supports.EnterActionAndIndent;
import org.eclipse.tm4e.languageconfiguration.internal.utils.TabSpacesInfo;
import org.eclipse.tm4e.languageconfiguration.internal.utils.TextUtils;
import org.eclipse.tm4e.ui.utils.ContentTypeHelper;
import org.eclipse.tm4e.ui.utils.ContentTypeInfo;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class LanguageConfigurationAutoEditStrategy
implements IAutoEditStrategy {
    private IDocument document;
    private IContentType[] contentTypes;
    private TabSpacesInfo tabSpacesInfo;
    private ITextViewer viewer;

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        IContentType[] contentTypes = this.findContentTypes(document);
        if (contentTypes == null) {
            return;
        }
        this.installViewer();
        if (TextUtils.isEnter(document, command)) {
            this.onEnter(document, command, false);
            return;
        }
        LanguageConfigurationRegistry registry = LanguageConfigurationRegistry.getInstance();
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            List<AutoClosingPair> autoClosingPairs = registry.getAutoClosingPairs(contentType.getId());
            if (autoClosingPairs != null && autoClosingPairs.size() > 0) {
                for (AutoClosingPair autoClosingPair : autoClosingPairs) {
                    if (!command.text.equals(autoClosingPair.getOpen())) continue;
                    command.text = String.valueOf(command.text) + autoClosingPair.getClose();
                    command.caretOffset = command.offset + 1;
                    command.shiftsCaret = false;
                    break;
                }
            }
            ++n2;
        }
    }

    private void onEnter(IDocument document, DocumentCommand command, boolean keepPosition) {
        String typeText;
        LanguageConfigurationRegistry registry = LanguageConfigurationRegistry.getInstance();
        IContentType[] iContentTypeArray = this.contentTypes;
        int n = this.contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            EnterActionAndIndent r = registry.getEnterAction(document, command.offset, contentType.getId());
            if (r != null) {
                EnterAction enterAction = r.getEnterAction();
                String indentation = r.getIndentation();
                String delim = command.text;
                switch (enterAction.getIndentAction()) {
                    case None: {
                        String typeText2;
                        String increasedIndent = this.normalizeIndentation(String.valueOf(indentation) + enterAction.getAppendText());
                        command.text = typeText2 = String.valueOf(delim) + increasedIndent;
                        command.shiftsCaret = false;
                        if (keepPosition) break;
                        command.caretOffset = command.offset + (String.valueOf(delim) + increasedIndent).length();
                        break;
                    }
                    case Indent: {
                        String typeText3;
                        String increasedIndent = this.normalizeIndentation(String.valueOf(indentation) + enterAction.getAppendText());
                        command.text = typeText3 = String.valueOf(delim) + increasedIndent;
                        command.shiftsCaret = false;
                        if (keepPosition) break;
                        command.caretOffset = command.offset + (String.valueOf(delim) + increasedIndent).length();
                        break;
                    }
                    case IndentOutdent: {
                        String typeText4;
                        String normalIndent = this.normalizeIndentation(indentation);
                        String increasedIndent = this.normalizeIndentation(String.valueOf(indentation) + enterAction.getAppendText());
                        command.text = typeText4 = String.valueOf(delim) + increasedIndent + delim + normalIndent;
                        command.shiftsCaret = false;
                        if (keepPosition) break;
                        command.caretOffset = command.offset + (String.valueOf(delim) + increasedIndent).length();
                        break;
                    }
                }
                return;
            }
            ++n2;
        }
        String indentation = TextUtils.getIndentationAtPosition(document, command.offset);
        String increasedIndent = this.normalizeIndentation(indentation);
        String delim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        command.text = typeText = String.valueOf(delim) + increasedIndent;
        command.shiftsCaret = false;
        if (!keepPosition) {
            command.caretOffset = command.offset + (String.valueOf(delim) + increasedIndent).length();
        }
    }

    private IContentType[] findContentTypes(IDocument document) {
        if (this.document != null && this.document.equals(document)) {
            return this.contentTypes;
        }
        try {
            ContentTypeInfo info = ContentTypeHelper.findContentTypes((IDocument)document);
            this.contentTypes = info.getContentTypes();
            this.document = document;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return this.contentTypes;
    }

    private String normalizeIndentation(String str) {
        TabSpacesInfo tabSpaces = this.getTabSpaces();
        return TextUtils.normalizeIndentation(str, tabSpaces.getTabSize(), tabSpaces.isInsertSpaces());
    }

    private TabSpacesInfo getTabSpaces() {
        if (this.tabSpacesInfo != null) {
            return this.tabSpacesInfo;
        }
        this.tabSpacesInfo = TextUtils.getTabSpaces(this.viewer);
        return this.tabSpacesInfo;
    }

    private void installViewer() {
        IWorkbenchPage page;
        IEditorPart editorPart;
        ITextOperationTarget target;
        if (this.viewer == null && (target = (ITextOperationTarget)(editorPart = (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).getActiveEditor()).getAdapter(ITextOperationTarget.class)) instanceof ITextViewer) {
            this.viewer = (ITextViewer)target;
        }
    }
}

