/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.cargo.core;

import java.util.Arrays;
import java.util.List;
import org.eclipse.corrosion.Messages;

public class CLIOption {
    private String flag;
    private String[] arguments;
    private String description;

    public CLIOption(List<String> lines) {
        if (lines == null || lines.isEmpty() || !lines.get(0).matches("\\s*-+.*")) {
            throw new IllegalArgumentException(Messages.CLIOption_lineIsNotHelp);
        }
        String[] firstLine = lines.get(0).trim().split("  ");
        int start = firstLine[0].lastIndexOf(", ");
        start = start == -1 ? 0 : start + 2;
        String[] flagSection = firstLine[0].substring(start).split("\\s");
        this.flag = flagSection[0];
        this.arguments = Arrays.copyOfRange(flagSection, 1, flagSection.length);
        StringBuilder descriptionBuilder = new StringBuilder(String.join((CharSequence)"  ", Arrays.copyOfRange(firstLine, 1, firstLine.length)).trim());
        lines.remove(0);
        for (String string : lines) {
            descriptionBuilder.append(string.trim());
        }
        this.description = descriptionBuilder.toString();
    }

    public String getFlag() {
        return this.flag;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String getDescription(int length) {
        if (length > this.description.length()) {
            return this.description;
        }
        if (length > 3) {
            return this.description.substring(0, length - 3);
        }
        return this.description.substring(0, length);
    }
}

