/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.model;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.tm4e.core.model.AbstractLineList;
import org.eclipse.tm4e.ui.internal.model.DocumentHelper;

public class DocumentLineList
extends AbstractLineList {
    private final IDocument document;
    private InternalListener listener;

    public DocumentLineList(IDocument document) {
        this.document = document;
        this.listener = new InternalListener();
        document.addDocumentListener((IDocumentListener)this.listener);
    }

    public int getNumberOfLines() {
        return DocumentHelper.getNumberOfLines(this.document);
    }

    public String getLineText(int line) throws Exception {
        return DocumentHelper.getLineText(this.document, line, false);
    }

    public int getLineLength(int line) throws Exception {
        return DocumentHelper.getLineLength(this.document, line);
    }

    public void dispose() {
        this.document.removeDocumentListener((IDocumentListener)this.listener);
    }

    private class InternalListener
    implements IDocumentListener {
        private InternalListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            try {
                if (!DocumentHelper.isInsert(event)) {
                    this.removeLine(event);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        private void removeLine(DocumentEvent event) throws BadLocationException {
            int endLine;
            int startLine = DocumentHelper.getStartLine(event);
            int i = endLine = DocumentHelper.getEndLine(event, true);
            while (i > startLine) {
                DocumentLineList.this.removeLine(i);
                --i;
            }
        }

        public void documentChanged(DocumentEvent event) {
            IDocument document = event.getDocument();
            try {
                int startLine = DocumentHelper.getStartLine(event);
                if (!DocumentHelper.isRemove(event)) {
                    if (DocumentLineList.this.getSize() != DocumentHelper.getNumberOfLines(document)) {
                        int endLine = DocumentHelper.getEndLine(event, false);
                        int i = startLine;
                        while (i < endLine) {
                            DocumentLineList.this.addLine(i + 1);
                            ++i;
                        }
                    } else {
                        DocumentLineList.this.updateLine(startLine);
                    }
                } else {
                    DocumentLineList.this.updateLine(startLine);
                }
                DocumentLineList.this.invalidateLine(startLine);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }
}

