/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.lsp4e.DocumentContentSynchronizer;
import org.eclipse.lsp4e.FileBufferListenerAdapter;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageClientImpl;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LoggingStreamConnectionProviderProxy;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeActionCapabilities;
import org.eclipse.lsp4j.CodeActionKindCapabilities;
import org.eclipse.lsp4j.CodeActionLiteralSupportCapabilities;
import org.eclipse.lsp4j.CodeLensCapabilities;
import org.eclipse.lsp4j.ColorProviderCapabilities;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.CompletionItemCapabilities;
import org.eclipse.lsp4j.DefinitionCapabilities;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.DocumentHighlightCapabilities;
import org.eclipse.lsp4j.DocumentLinkCapabilities;
import org.eclipse.lsp4j.DocumentSymbolCapabilities;
import org.eclipse.lsp4j.ExecuteCommandCapabilities;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.FormattingCapabilities;
import org.eclipse.lsp4j.HoverCapabilities;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.RangeFormattingCapabilities;
import org.eclipse.lsp4j.ReferencesCapabilities;
import org.eclipse.lsp4j.Registration;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.RenameCapabilities;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelpCapabilities;
import org.eclipse.lsp4j.SymbolCapabilities;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.SymbolKindCapabilities;
import org.eclipse.lsp4j.SynchronizationCapabilities;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.TypeDefinitionCapabilities;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.WorkspaceEditCapabilities;
import org.eclipse.lsp4j.WorkspaceFoldersChangeEvent;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class LanguageServerWrapper {
    private IFileBufferListener fileBufferListener = new FileBufferListenerAdapter(){

        @Override
        public void bufferDisposed(IFileBuffer buffer) {
            Path filePath = new Path(buffer.getFileStore().toURI().getPath());
            LanguageServerWrapper.this.disconnect((IPath)filePath);
        }

        @Override
        public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
            if (isDirty) {
                return;
            }
            Path filePath = new Path(buffer.getFileStore().toURI().getPath());
            DocumentContentSynchronizer documentListener = LanguageServerWrapper.this.connectedDocuments.get(filePath);
            if (documentListener != null && documentListener.getModificationStamp() < buffer.getModificationStamp()) {
                documentListener.documentSaved(buffer.getModificationStamp());
            }
        }
    };
    public final  @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition;
    protected final @Nullable IProject initialProject;
    protected @NonNull Map<@NonNull IPath, @NonNull DocumentContentSynchronizer> connectedDocuments;
    protected final @Nullable IPath initialPath;
    protected StreamConnectionProvider lspStreamProvider;
    private Future<?> launcherFuture;
    private CompletableFuture<Void> initializeFuture;
    private LanguageServer languageServer;
    private ServerCapabilities serverCapabilities;
    private @NonNull Map<@NonNull String, @NonNull Runnable> dynamicRegistrations = new HashMap<String, Runnable>();
    private boolean initiallySupportsWorkspaceFolders = false;
    private final @NonNull IResourceChangeListener workspaceFolderUpdater = event -> {
        WorkspaceFoldersChangeEvent workspaceFolderEvent = LanguageServerWrapper.toWorkspaceFolderEvent(event);
        if (workspaceFolderEvent == null || workspaceFolderEvent.getAdded().isEmpty() && workspaceFolderEvent.getRemoved().isEmpty()) {
            return;
        }
        this.languageServer.getWorkspaceService().didChangeWorkspaceFolders(new DidChangeWorkspaceFoldersParams(workspaceFolderEvent));
    };

    public LanguageServerWrapper(@NonNull IProject project,  @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition) {
        this(project, serverDefinition, null);
    }

    public LanguageServerWrapper( @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition, @Nullable IPath initialPath) {
        this(null, serverDefinition, initialPath);
    }

    private LanguageServerWrapper(@Nullable IProject project,  @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition, @Nullable IPath initialPath) {
        this.initialProject = project;
        this.initialPath = initialPath;
        this.serverDefinition = serverDefinition;
        this.connectedDocuments = new HashMap<IPath, DocumentContentSynchronizer>();
    }

    public synchronized void start() throws IOException {
        Map<IPath, IDocument> filesToReconnect = Collections.emptyMap();
        if (this.languageServer != null) {
            if (this.isActive()) {
                return;
            }
            filesToReconnect = new HashMap();
            for (Map.Entry<IPath, DocumentContentSynchronizer> entry : this.connectedDocuments.entrySet()) {
                filesToReconnect.put(entry.getKey(), entry.getValue().getDocument());
            }
            this.stop();
        }
        try {
            this.lspStreamProvider = LoggingStreamConnectionProviderProxy.shouldLog(this.serverDefinition.id) ? new LoggingStreamConnectionProviderProxy(this.serverDefinition.createConnectionProvider(), this.serverDefinition.id) : this.serverDefinition.createConnectionProvider();
            this.lspStreamProvider.start();
            LanguageClientImpl client = this.serverDefinition.createLanguageClient();
            ExecutorService executorService = Executors.newCachedThreadPool();
            InitializeParams initParams = new InitializeParams();
            initParams.setProcessId(this.getCurrentProcessId());
            URI rootURI = null;
            IProject project = this.initialProject;
            if (project != null && project.exists()) {
                rootURI = LSPEclipseUtils.toUri((IResource)this.initialProject);
                initParams.setRootUri(rootURI.toString());
                initParams.setRootPath(rootURI.getPath());
            } else {
                IPath initialPath = this.initialPath;
                if (initialPath != null) {
                    File projectDirectory = initialPath.toFile();
                    if (projectDirectory.isFile()) {
                        projectDirectory = projectDirectory.getParentFile();
                    }
                    initParams.setRootUri(LSPEclipseUtils.toUri(projectDirectory).toString());
                } else {
                    initParams.setRootUri(LSPEclipseUtils.toUri(new File("/")).toString());
                }
            }
            UnaryOperator wrapper = consumer -> message -> {
                consumer.consume(message);
                this.logMessage(message);
                URI root = initParams.getRootUri() != null ? URI.create(initParams.getRootUri()) : null;
                StreamConnectionProvider currentConnectionProvider = this.lspStreamProvider;
                if (currentConnectionProvider != null && this.isActive()) {
                    currentConnectionProvider.handleMessage(message, this.languageServer, root);
                }
            };
            Launcher launcher = this.serverDefinition.createLauncherBuilder().setLocalService((Object)client).setRemoteInterface(this.serverDefinition.getServerInterface()).setInput(this.lspStreamProvider.getInputStream()).setOutput(this.lspStreamProvider.getOutputStream()).setExecutorService(executorService).wrapMessages((Function)wrapper).create();
            this.languageServer = (LanguageServer)launcher.getRemoteProxy();
            client.connect(this.languageServer, this);
            this.launcherFuture = launcher.startListening();
            String name = "Eclipse IDE";
            if (Platform.getProduct() != null) {
                name = Platform.getProduct().getName();
            }
            WorkspaceClientCapabilities workspaceClientCapabilities = new WorkspaceClientCapabilities();
            workspaceClientCapabilities.setApplyEdit(Boolean.TRUE);
            workspaceClientCapabilities.setExecuteCommand(new ExecuteCommandCapabilities(Boolean.TRUE));
            workspaceClientCapabilities.setSymbol(new SymbolCapabilities(Boolean.TRUE));
            workspaceClientCapabilities.setWorkspaceFolders(Boolean.TRUE);
            WorkspaceEditCapabilities editCapabilities = new WorkspaceEditCapabilities();
            editCapabilities.setDocumentChanges(Boolean.TRUE);
            editCapabilities.setResourceOperations(Arrays.asList("create", "delete", "rename"));
            editCapabilities.setFailureHandling("undo");
            workspaceClientCapabilities.setWorkspaceEdit(editCapabilities);
            TextDocumentClientCapabilities textDocumentClientCapabilities = new TextDocumentClientCapabilities();
            textDocumentClientCapabilities.setCodeAction(new CodeActionCapabilities(new CodeActionLiteralSupportCapabilities(new CodeActionKindCapabilities(Arrays.asList("quickfix", "refactor", "refactor.extract", "refactor.inline", "refactor.rewrite", "source", "source.organizeImports"))), Boolean.valueOf(true)));
            textDocumentClientCapabilities.setCodeLens(new CodeLensCapabilities());
            textDocumentClientCapabilities.setColorProvider(new ColorProviderCapabilities());
            CompletionItemCapabilities completionItemCapabilities = new CompletionItemCapabilities(Boolean.TRUE);
            completionItemCapabilities.setDocumentationFormat(Arrays.asList("markdown", "plaintext"));
            textDocumentClientCapabilities.setCompletion(new CompletionCapabilities(completionItemCapabilities));
            DefinitionCapabilities definitionCapabilities = new DefinitionCapabilities();
            definitionCapabilities.setLinkSupport(Boolean.TRUE);
            textDocumentClientCapabilities.setDefinition(definitionCapabilities);
            TypeDefinitionCapabilities typeDefinitionCapabilities = new TypeDefinitionCapabilities();
            typeDefinitionCapabilities.setLinkSupport(Boolean.TRUE);
            textDocumentClientCapabilities.setTypeDefinition(typeDefinitionCapabilities);
            textDocumentClientCapabilities.setDocumentHighlight(new DocumentHighlightCapabilities());
            textDocumentClientCapabilities.setDocumentLink(new DocumentLinkCapabilities());
            DocumentSymbolCapabilities documentSymbol = new DocumentSymbolCapabilities();
            documentSymbol.setHierarchicalDocumentSymbolSupport(Boolean.valueOf(true));
            documentSymbol.setSymbolKind(new SymbolKindCapabilities(Arrays.asList(SymbolKind.Array, SymbolKind.Boolean, SymbolKind.Class, SymbolKind.Constant, SymbolKind.Constructor, SymbolKind.Enum, SymbolKind.EnumMember, SymbolKind.Event, SymbolKind.Field, SymbolKind.File, SymbolKind.Function, SymbolKind.Interface, SymbolKind.Key, SymbolKind.Method, SymbolKind.Module, SymbolKind.Namespace, SymbolKind.Null, SymbolKind.Number, SymbolKind.Object, SymbolKind.Operator, SymbolKind.Package, SymbolKind.Property, SymbolKind.String, SymbolKind.Struct, SymbolKind.TypeParameter, SymbolKind.Variable)));
            textDocumentClientCapabilities.setDocumentSymbol(documentSymbol);
            textDocumentClientCapabilities.setFormatting(new FormattingCapabilities(Boolean.TRUE));
            HoverCapabilities hoverCapabilities = new HoverCapabilities();
            hoverCapabilities.setContentFormat(Arrays.asList("markdown", "plaintext"));
            textDocumentClientCapabilities.setHover(hoverCapabilities);
            textDocumentClientCapabilities.setOnTypeFormatting(null);
            textDocumentClientCapabilities.setRangeFormatting(new RangeFormattingCapabilities());
            textDocumentClientCapabilities.setReferences(new ReferencesCapabilities());
            textDocumentClientCapabilities.setRename(new RenameCapabilities());
            textDocumentClientCapabilities.setSignatureHelp(new SignatureHelpCapabilities());
            textDocumentClientCapabilities.setSynchronization(new SynchronizationCapabilities(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE));
            initParams.setCapabilities(new ClientCapabilities(workspaceClientCapabilities, textDocumentClientCapabilities, this.lspStreamProvider.getExperimentalFeaturesPOJO()));
            initParams.setClientName(name);
            initParams.setInitializationOptions(this.lspStreamProvider.getInitializationOptions(rootURI));
            initParams.setTrace(this.lspStreamProvider.getTrace(rootURI));
            this.initializeFuture = ((CompletableFuture)this.languageServer.initialize(initParams).thenAccept(res -> {
                this.serverCapabilities = res.getCapabilities();
                this.initiallySupportsWorkspaceFolders = LanguageServerWrapper.supportsWorkspaceFolders(this.serverCapabilities);
            })).thenRun(() -> this.languageServer.initialized(new InitializedParams()));
            Map<IPath, IDocument> toReconnect = filesToReconnect;
            this.initializeFuture.thenRunAsync(() -> {
                this.watchProjects();
                for (Map.Entry fileToReconnect : toReconnect.entrySet()) {
                    try {
                        this.connect((IPath)fileToReconnect.getKey(), (IDocument)fileToReconnect.getValue());
                    }
                    catch (IOException e) {
                        LanguageServerPlugin.logError(e);
                    }
                }
            });
            FileBuffers.getTextFileBufferManager().addFileBufferListener(this.fileBufferListener);
        }
        catch (Exception ex) {
            LanguageServerPlugin.logError(ex);
            this.stop();
        }
    }

    private static boolean supportsWorkspaceFolders(ServerCapabilities serverCapabilities) {
        return serverCapabilities != null && serverCapabilities.getWorkspace() != null && serverCapabilities.getWorkspace().getWorkspaceFolders() != null && Boolean.TRUE.equals(serverCapabilities.getWorkspace().getWorkspaceFolders().getSupported());
    }

    private Integer getCurrentProcessId() {
        String segment = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        try {
            return Integer.valueOf(segment);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private void logMessage(Message message) {
        if (message instanceof ResponseMessage && ((ResponseMessage)message).getError() != null && ((ResponseMessage)message).getId().equals(Integer.toString(ResponseErrorCode.RequestCancelled.getValue()))) {
            ResponseMessage responseMessage = (ResponseMessage)message;
            LanguageServerPlugin.logError((Throwable)new ResponseErrorException(responseMessage.getError()));
        } else if (LanguageServerPlugin.DEBUG) {
            LanguageServerPlugin.logInfo(String.valueOf(message.getClass().getSimpleName()) + '\n' + message.toString());
        }
    }

    public boolean isActive() {
        return this.launcherFuture != null && !this.launcherFuture.isDone() && !this.launcherFuture.isCancelled();
    }

    synchronized void stop() {
        if (this.initializeFuture != null) {
            this.initializeFuture.cancel(true);
            this.initializeFuture = null;
        }
        this.serverCapabilities = null;
        this.dynamicRegistrations.clear();
        Future<?> serverFuture = this.launcherFuture;
        StreamConnectionProvider provider = this.lspStreamProvider;
        LanguageServer languageServerInstance = this.languageServer;
        Runnable shutdownKillAndStopFutureAndProvider = () -> {
            if (languageServerInstance != null) {
                CompletableFuture shutdown = languageServerInstance.shutdown();
                try {
                    shutdown.get(5L, TimeUnit.SECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (serverFuture != null) {
                serverFuture.cancel(true);
            }
            if (languageServerInstance != null) {
                languageServerInstance.exit();
            }
            if (provider != null) {
                provider.stop();
            }
        };
        CompletableFuture.runAsync(shutdownKillAndStopFutureAndProvider);
        this.launcherFuture = null;
        this.lspStreamProvider = null;
        while (!this.connectedDocuments.isEmpty()) {
            this.disconnect(this.connectedDocuments.keySet().iterator().next());
        }
        this.languageServer = null;
        FileBuffers.getTextFileBufferManager().removeFileBufferListener(this.fileBufferListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.workspaceFolderUpdater);
    }

    public @Nullable CompletableFuture<LanguageServer> connect(@NonNull IFile file, IDocument document) throws IOException {
        return this.connect(file.getLocation(), document);
    }

    public @Nullable CompletableFuture<LanguageServer> connect(IDocument document) throws IOException {
        IFile file = LSPEclipseUtils.getFile(document);
        if (file != null && file.exists()) {
            return this.connect(file, document);
        }
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri != null) {
            return this.connect((IPath)new Path(LSPEclipseUtils.toUri(document).getPath()), document);
        }
        return null;
    }

    private void watchProjects() {
        if (!this.supportsWorkspaceFolderCapability()) {
            return;
        }
        try {
            ResourcesPlugin.getWorkspace().run(monitor -> {
                WorkspaceFoldersChangeEvent wsFolderEvent = new WorkspaceFoldersChangeEvent();
                wsFolderEvent.getAdded().addAll(Arrays.stream(ResourcesPlugin.getWorkspace().getRoot().getProjects()).filter(IResource::isAccessible).map(LSPEclipseUtils::toWorkspaceFolder).collect(Collectors.toList()));
                this.languageServer.getWorkspaceService().didChangeWorkspaceFolders(new DidChangeWorkspaceFoldersParams(wsFolderEvent));
                ResourcesPlugin.getWorkspace().addResourceChangeListener(this.workspaceFolderUpdater, 1);
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            LanguageServerPlugin.logError(e);
        }
    }

    private static final @Nullable WorkspaceFoldersChangeEvent toWorkspaceFolderEvent(IResourceChangeEvent e) {
        if (e.getType() != 1) {
            return null;
        }
        WorkspaceFoldersChangeEvent wsFolderEvent = new WorkspaceFoldersChangeEvent();
        try {
            e.getDelta().accept(delta -> {
                if (delta.getResource().getType() == 4) {
                    IProject project = (IProject)delta.getResource();
                    if ((delta.getKind() == 1 || delta.getKind() == 16384) && project.isAccessible()) {
                        wsFolderEvent.getAdded().add(LSPEclipseUtils.toWorkspaceFolder((IProject)delta.getResource()));
                    } else if (delta.getKind() == 2 || delta.getKind() == 16384 && !project.isAccessible()) {
                        wsFolderEvent.getRemoved().add(LSPEclipseUtils.toWorkspaceFolder((IProject)delta.getResource()));
                    }
                }
                return delta.getResource().getType() == 8;
            });
        }
        catch (CoreException ex) {
            LanguageServerPlugin.logError(ex);
        }
        if (wsFolderEvent.getAdded().isEmpty() && wsFolderEvent.getRemoved().isEmpty()) {
            return null;
        }
        return wsFolderEvent;
    }

    public boolean canOperate(IProject project) {
        return project.equals((Object)this.initialProject) || this.serverDefinition.isSingleton || this.supportsWorkspaceFolderCapability();
    }

    private boolean supportsWorkspaceFolderCapability() {
        if (this.initializeFuture != null) {
            try {
                this.initializeFuture.get(1L, TimeUnit.SECONDS);
            }
            catch (ExecutionException | TimeoutException e) {
                LanguageServerPlugin.logError(e);
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
            }
        }
        return this.initiallySupportsWorkspaceFolders || LanguageServerWrapper.supportsWorkspaceFolders(this.serverCapabilities);
    }

    private CompletableFuture<LanguageServer> connect(@NonNull IPath absolutePath, IDocument document) throws IOException {
        IPath thePath = Path.fromOSString((String)absolutePath.toFile().getAbsolutePath());
        if (this.connectedDocuments.containsKey(thePath)) {
            return CompletableFuture.completedFuture(this.languageServer);
        }
        this.start();
        if (this.initializeFuture == null) {
            return null;
        }
        if (document == null) {
            IFile docFile = (IFile)LSPEclipseUtils.findResourceFor(thePath.toFile().toURI().toString());
            document = LSPEclipseUtils.getDocument((IResource)docFile);
        }
        if (document == null) {
            return null;
        }
        IDocument theDocument = document;
        return ((CompletableFuture)this.initializeFuture.thenComposeAsync(theVoid -> {
            Map<IPath, DocumentContentSynchronizer> map = this.connectedDocuments;
            synchronized (map) {
                if (this.connectedDocuments.containsKey(thePath)) {
                    return CompletableFuture.completedFuture(null);
                }
                Either syncOptions = this.initializeFuture == null ? null : this.serverCapabilities.getTextDocumentSync();
                TextDocumentSyncKind syncKind = null;
                if (syncOptions != null) {
                    if (syncOptions.isRight()) {
                        syncKind = ((TextDocumentSyncOptions)syncOptions.getRight()).getChange();
                    } else if (syncOptions.isLeft()) {
                        syncKind = (TextDocumentSyncKind)syncOptions.getLeft();
                    }
                }
                DocumentContentSynchronizer listener = new DocumentContentSynchronizer(this, theDocument, syncKind);
                theDocument.addDocumentListener((IDocumentListener)listener);
                this.connectedDocuments.put(thePath, listener);
                return listener.didOpenFuture;
            }
        })).thenApply(theVoid -> this.languageServer);
    }

    public void disconnect(IPath path) {
        DocumentContentSynchronizer documentListener = this.connectedDocuments.remove(path);
        if (documentListener != null) {
            documentListener.getDocument().removeDocumentListener((IDocumentListener)documentListener);
            documentListener.documentClosed();
        }
        if (this.connectedDocuments.isEmpty()) {
            this.stop();
        }
    }

    public void disconnectContentType(@NonNull IContentType contentType) {
        ArrayList<IPath> pathsToDisconnect = new ArrayList<IPath>();
        for (IPath path : this.connectedDocuments.keySet()) {
            IFile[] foundFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(path.toFile().toURI());
            if (foundFiles.length == 0) continue;
            if (!LSPEclipseUtils.getFileContentTypes(foundFiles[0]).stream().anyMatch(contentType::equals)) continue;
            pathsToDisconnect.add(path);
        }
        for (IPath path : pathsToDisconnect) {
            this.disconnect(path);
        }
    }

    public boolean isConnectedTo(IPath location) {
        return this.connectedDocuments.containsKey(location);
    }

    @Deprecated
    public @Nullable LanguageServer getServer() {
        CompletableFuture<LanguageServer> languagServerFuture = this.getInitializedServer();
        if (Display.getCurrent() != null) {
            return this.languageServer;
        }
        return languagServerFuture.join();
    }

    public @NonNull CompletableFuture<LanguageServer> getInitializedServer() {
        try {
            this.start();
        }
        catch (IOException ex) {
            LanguageServerPlugin.logError(ex);
        }
        if (this.initializeFuture != null && !this.initializeFuture.isDone()) {
            if (Display.getCurrent() != null) {
                Job waitForInitialization = new Job(Messages.initializeLanguageServer_job){

                    protected IStatus run(IProgressMonitor monitor) {
                        LanguageServerWrapper.this.initializeFuture.join();
                        return Status.OK_STATUS;
                    }
                };
                waitForInitialization.setUser(true);
                waitForInitialization.setSystem(false);
                PlatformUI.getWorkbench().getProgressService().showInDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), waitForInitialization);
            }
            return this.initializeFuture.thenApply(r -> this.languageServer);
        }
        return CompletableFuture.completedFuture(this.languageServer);
    }

    public @Nullable ServerCapabilities getServerCapabilities() {
        try {
            this.getInitializedServer().get(10L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            LanguageServerPlugin.logError("LanguageServer not initialized after 10s", e);
        }
        catch (ExecutionException e) {
            LanguageServerPlugin.logError(e);
        }
        catch (CancellationException e) {
            LanguageServerPlugin.logError(e);
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            Thread.currentThread().interrupt();
        }
        return this.serverCapabilities;
    }

    public @Nullable String getLanguageId(IContentType[] contentTypes) {
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            String languageId = this.serverDefinition.langugeIdMappings.get(contentType);
            if (languageId != null) {
                return languageId;
            }
            ++n2;
        }
        return null;
    }

    void registerCapability(RegistrationParams params) {
        params.getRegistrations().forEach(reg -> {
            if ("workspace/didChangeWorkspaceFolders".equals(reg.getMethod())) {
                Assert.isNotNull((Object)this.serverCapabilities, (String)"Dynamic capability registration failed! Server not yet initialized?");
                if (!this.initiallySupportsWorkspaceFolders) {
                    if (LanguageServerWrapper.supportsWorkspaceFolders(this.serverCapabilities)) {
                        LanguageServerPlugin.logWarning("Dynamic registration of 'workspace/didChangeWorkspaceFolders' ignored. It was already enabled before", null);
                    } else {
                        this.addRegistration((Registration)reg, () -> this.setWorkspaceFoldersEnablement(false));
                        this.setWorkspaceFoldersEnablement(true);
                    }
                }
            } else if ("workspace/executeCommand".equals(reg.getMethod())) {
                Gson gson = new Gson();
                ExecuteCommandOptions executeCommandOptions = (ExecuteCommandOptions)gson.fromJson((JsonElement)((JsonObject)reg.getRegisterOptions()), ExecuteCommandOptions.class);
                List newCommands = executeCommandOptions.getCommands();
                if (!newCommands.isEmpty()) {
                    this.addRegistration((Registration)reg, () -> this.unregisterCommands(newCommands));
                    this.registerCommands(newCommands);
                }
            } else if ("textDocument/formatting".equals(reg.getMethod())) {
                Boolean beforeRegistration = this.serverCapabilities.getDocumentFormattingProvider();
                this.serverCapabilities.setDocumentFormattingProvider(Boolean.TRUE);
                this.addRegistration((Registration)reg, () -> this.serverCapabilities.setDocumentFormattingProvider(beforeRegistration));
            } else if ("textDocument/rangeFormatting".equals(reg.getMethod())) {
                Boolean beforeRegistration = this.serverCapabilities.getDocumentRangeFormattingProvider();
                this.serverCapabilities.setDocumentRangeFormattingProvider(Boolean.TRUE);
                this.addRegistration((Registration)reg, () -> this.serverCapabilities.setDocumentRangeFormattingProvider(beforeRegistration));
            } else if ("textDocument/codeAction".equals(reg.getMethod())) {
                Either beforeRegistration = this.serverCapabilities.getCodeActionProvider();
                this.serverCapabilities.setCodeActionProvider(Boolean.TRUE);
                this.addRegistration((Registration)reg, () -> this.serverCapabilities.setCodeActionProvider(beforeRegistration));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRegistration(@NonNull Registration reg, @NonNull Runnable unregistrationHandler) {
        String regId = reg.getId();
        Map<String, Runnable> map = this.dynamicRegistrations;
        synchronized (map) {
            Assert.isLegal((!this.dynamicRegistrations.containsKey(regId) ? 1 : 0) != 0, (String)"Registration id is not unique");
            this.dynamicRegistrations.put(regId, unregistrationHandler);
        }
    }

    synchronized void setWorkspaceFoldersEnablement(boolean enable) {
        WorkspaceFoldersOptions folders;
        WorkspaceServerCapabilities workspace;
        if (enable == this.supportsWorkspaceFolderCapability()) {
            return;
        }
        if (this.serverCapabilities == null) {
            this.serverCapabilities = new ServerCapabilities();
        }
        if ((workspace = this.serverCapabilities.getWorkspace()) == null) {
            workspace = new WorkspaceServerCapabilities();
            this.serverCapabilities.setWorkspace(workspace);
        }
        if ((folders = workspace.getWorkspaceFolders()) == null) {
            folders = new WorkspaceFoldersOptions();
            workspace.setWorkspaceFolders(folders);
        }
        folders.setSupported(Boolean.valueOf(enable));
        if (enable) {
            this.watchProjects();
        }
    }

    synchronized void registerCommands(List<String> newCommands) {
        ServerCapabilities caps = this.getServerCapabilities();
        if (caps != null) {
            ExecuteCommandOptions commandProvider = caps.getExecuteCommandProvider();
            if (commandProvider == null) {
                commandProvider = new ExecuteCommandOptions(new ArrayList());
                caps.setExecuteCommandProvider(commandProvider);
            }
            List existingCommands = commandProvider.getCommands();
            for (String newCmd : newCommands) {
                Assert.isLegal((!existingCommands.contains(newCmd) ? 1 : 0) != 0, (String)("Command already registered '" + newCmd + "'"));
                existingCommands.add(newCmd);
            }
        } else {
            throw new IllegalStateException("Dynamic command registration failed! Server not yet initialized?");
        }
    }

    void unregisterCapability(UnregistrationParams params) {
        params.getUnregisterations().forEach(reg -> {
            Runnable unregistrator;
            String id = reg.getId();
            Map<String, Runnable> map = this.dynamicRegistrations;
            synchronized (map) {
                unregistrator = this.dynamicRegistrations.get(id);
                this.dynamicRegistrations.remove(id);
            }
            if (unregistrator != null) {
                unregistrator.run();
            }
        });
    }

    void unregisterCommands(List<String> cmds) {
        ExecuteCommandOptions commandProvider;
        ServerCapabilities caps = this.getServerCapabilities();
        if (caps != null && (commandProvider = caps.getExecuteCommandProvider()) != null) {
            List existingCommands = commandProvider.getCommands();
            existingCommands.removeAll(cmds);
        }
    }

    int getVersion(IFile file) {
        DocumentContentSynchronizer documentContentSynchronizer;
        if (file != null && file.getLocation() != null && (documentContentSynchronizer = this.connectedDocuments.get(file.getLocation())) != null) {
            return documentContentSynchronizer.getVersion();
        }
        return -1;
    }

    public boolean canOperate(@NonNull IDocument document) {
        URI documentUri = LSPEclipseUtils.toUri(document);
        if (documentUri == null) {
            return false;
        }
        if (this.isConnectedTo((IPath)new Path(documentUri.getPath()))) {
            return true;
        }
        if (this.initialProject == null && this.connectedDocuments.isEmpty()) {
            return true;
        }
        IFile file = LSPEclipseUtils.getFile(document);
        if (file != null && file.exists() && this.canOperate(file.getProject())) {
            return true;
        }
        return this.serverDefinition.isSingleton || this.supportsWorkspaceFolderCapability();
    }
}

