/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.symbols;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.symbols.LSPSymbolInFileDialog;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPSymbolInFileHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (part instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)part;
            List<LanguageServiceAccessor.LSPDocumentInfo> infos = LanguageServiceAccessor.getLSPDocumentInfosFor(LSPEclipseUtils.getDocument(textEditor), capabilities -> Boolean.TRUE.equals(capabilities.getDocumentSymbolProvider()));
            if (infos.isEmpty()) {
                return null;
            }
            LanguageServiceAccessor.LSPDocumentInfo info = (LanguageServiceAccessor.LSPDocumentInfo)infos.iterator().next();
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            DocumentSymbolParams params = new DocumentSymbolParams(new TextDocumentIdentifier(info.getFileUri().toString()));
            ((CompletableFuture)info.getInitializedLanguageClient().thenComposeAsync(langaugeServer -> langaugeServer.getTextDocumentService().documentSymbol(params))).thenAcceptAsync(t -> shell.getDisplay().asyncExec(() -> {
                LSPSymbolInFileDialog dialog = new LSPSymbolInFileDialog(shell, textEditor, info.getFileUri(), (List<Either<SymbolInformation, DocumentSymbol>>)t);
                dialog.open();
            }));
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (part instanceof ITextEditor) {
            List<LanguageServiceAccessor.LSPDocumentInfo> infos = LanguageServiceAccessor.getLSPDocumentInfosFor(LSPEclipseUtils.getDocument((ITextEditor)part), capabilities -> Boolean.TRUE.equals(capabilities.getDocumentSymbolProvider()));
            return !infos.isEmpty();
        }
        return false;
    }
}

