/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.fastxpath.compiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CodeGenerationError;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompiledXPathExpression;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.FastXPathClassGenerator;
import org.eclipse.tptp.platform.provisional.fastxpath.utils.EclipseUtils;

public class JDTCompiler
implements FastXPathClassGenerator {
    public static String JAVA_COMPILE_METHOD = "compile";
    public static String JAVA_COMPILER_CLASS = JDTCompiler.getInverse("niaM.hctab.relipmoc.lanretni.tdj.espilce.gro");
    public static String classPath = null;
    private static MyClassLoader classLoader = null;
    private static File tempDirectory;
    private static String[] arguments;
    private static int argsCount;
    private static URLClassLoader urlClassLoader;
    private static boolean verboseOutput;
    private byte[] bytes;
    private Object compiler;
    private Method compileMethod;
    private ByteArrayOutputStream javaCompileErrorStream;
    private ByteArrayOutputStream javaCompileOutputStream;
    private static String pathSeparator;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        verboseOutput = false;
        pathSeparator = File.pathSeparator;
        String tempDirectoryString = String.valueOf(System.getProperty("java.io.tmpdir")) + "fastxpath-temp";
        tempDirectory = new File(tempDirectoryString);
        tempDirectory.mkdirs();
        tempDirectory.deleteOnExit();
        ArrayList<String> execParmsAL = new ArrayList<String>();
        execParmsAL.add("-noExit");
        if (JDTCompiler.getClassPath() != null && classPath.length() > 0) {
            execParmsAL.add("-classpath");
            execParmsAL.add(classPath);
        }
        argsCount = execParmsAL.size() + 1;
        arguments = execParmsAL.toArray(new String[argsCount]);
        try {
            URL[] uRLArray = new URL[]{tempDirectory.toURL()};
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompilerHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            urlClassLoader = URLClassLoader.newInstance(uRLArray, clazz.getClassLoader());
        }
        catch (Exception exception) {}
    }

    public void addClassLoader(ClassLoader cl) {
    }

    public static String getInverse(String string) {
        StringBuffer sb = new StringBuffer();
        char[] cs = string.toCharArray();
        int i = cs.length - 1;
        while (i >= 0) {
            sb.append(cs[i]);
            --i;
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void batchCompile(List sources) {
        argsList = new ArrayList<String>();
        i = 0;
        while (true) {
            if (i >= JDTCompiler.argsCount - 1) break;
            argsList.add(JDTCompiler.arguments[i]);
            ++i;
        }
        i = 0;
        while (true) {
            if (i >= sources.size()) {
                argsArray = new String[argsList.size()];
                System.arraycopy(argsList.toArray(), 0, argsArray, 0, argsList.size());
                ** try [egrp 1[TRYBLOCK] [3 : 208->408)] { 
lbl15:
                // 1 sources

                break;
            }
            source = null;
            source = ((CompiledXPathExpression)sources.get(i)).getJavaSource();
            targetClassName = ((CompiledXPathExpression)sources.get(i)).getClassName();
            try {
                srcFile = new File(JDTCompiler.tempDirectory, String.valueOf(targetClassName) + ".java");
                srcFile.createNewFile();
                argsList.add(srcFile.getCanonicalPath());
                out = new PrintWriter(new FileOutputStream(srcFile));
                out.write(source, 0, source.length);
                out.flush();
                out.close();
                srcFile = null;
                out = null;
            }
            catch (IOException v0) {}
            ++i;
        }
        {
            try {
                this.initCompilerMethod();
                ok = (Boolean)this.compileMethod.invoke(this.compiler, new Object[]{argsArray});
                i = 0;
                while (true) {
                    if (i >= sources.size()) {
                        if (ok.booleanValue()) break;
                        throw new CodeGenerationError(this.javaCompileErrorStream.toString());
                    }
                    try {
                        targetClassName = ((CompiledXPathExpression)sources.get(i)).getClassName();
                        resourceName = String.valueOf(targetClassName) + ".class";
                        classFile = new File(JDTCompiler.tempDirectory, resourceName);
                        buf = null;
                        if (classFile.exists()) {
                            is = new FileInputStream(classFile);
                            buf = new byte[(int)classFile.length()];
                            is.read(buf, 0, buf.length);
                            is.close();
                        }
                        ((CompiledXPathExpression)sources.get(i)).setBytes(buf);
                    }
                    catch (Exception v1) {}
                    ++i;
                }
                ** GOTO lbl-1000
            }
            catch (Exception v2) {}
            ** GOTO lbl-1000
        }
lbl62:
        // 1 sources

        catch (Throwable var12_13) {
            var11_14 = null;
            i = 0;
        }
        while (true) {
            if (i >= sources.size()) {
                throw var12_13;
            }
            targetClassName = ((CompiledXPathExpression)sources.get(i)).getClassName();
            srcFile = new File(JDTCompiler.tempDirectory, String.valueOf(targetClassName) + ".java");
            if (srcFile.exists()) {
                srcFile.delete();
            }
            if ((classFile = new File(JDTCompiler.tempDirectory, String.valueOf(targetClassName) + ".class")).exists()) {
                classFile.delete();
            }
            ++i;
        }
lbl-1000:
        // 2 sources

        {
            var11_15 = null;
            i = 0;
        }
        while (true) {
            if (i >= sources.size()) {
                return;
            }
            targetClassName = ((CompiledXPathExpression)sources.get(i)).getClassName();
            srcFile = new File(JDTCompiler.tempDirectory, String.valueOf(targetClassName) + ".java");
            if (srcFile.exists()) {
                srcFile.delete();
            }
            if ((classFile = new File(JDTCompiler.tempDirectory, String.valueOf(targetClassName) + ".class")).exists()) {
                classFile.delete();
            }
            ++i;
        }
    }

    public Class generateClass(char[] source, String targetClassName) throws ClassNotFoundException, CodeGenerationError {
        File srcFile;
        String errorString;
        block6: {
            errorString = "";
            try {
                srcFile = new File(tempDirectory, String.valueOf(targetClassName) + ".java");
                srcFile.createNewFile();
                JDTCompiler.arguments[JDTCompiler.argsCount - 1] = srcFile.getCanonicalPath();
                PrintWriter out = new PrintWriter(new FileOutputStream(srcFile));
                out.write(source, 0, source.length);
                out.flush();
                out.close();
                this.initCompilerMethod();
                this.javaCompileOutputStream.reset();
                this.javaCompileErrorStream.reset();
                Boolean ok = (Boolean)this.compileMethod.invoke(this.compiler, new Object[]{arguments});
                errorString = this.javaCompileErrorStream.toString();
                if (!ok.booleanValue()) break block6;
                try {
                    Class<?> compilerOutput = Class.forName(targetClassName, true, urlClassLoader);
                    String resourceName = String.valueOf(targetClassName) + ".class";
                    File classFile = new File(tempDirectory, resourceName);
                    FileInputStream is = new FileInputStream(classFile);
                    if (is != null) {
                        this.bytes = new byte[(int)classFile.length()];
                        ((InputStream)is).read(this.bytes, 0, this.bytes.length);
                    }
                    ((InputStream)is).close();
                    classFile.delete();
                    srcFile.delete();
                    srcFile = null;
                    return compilerOutput;
                }
                catch (Exception exception) {
                    srcFile.delete();
                    return null;
                }
            }
            catch (Exception exception) {
                throw new CodeGenerationError(errorString);
            }
        }
        srcFile.delete();
        throw new CodeGenerationError(errorString);
    }

    protected void initCompilerMethod() throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, UnsupportedEncodingException {
        if (this.compiler == null) {
            this.javaCompileErrorStream = new ByteArrayOutputStream();
            this.javaCompileOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter esw = new OutputStreamWriter((OutputStream)this.javaCompileErrorStream, "UTF-8");
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)this.javaCompileOutputStream, "UTF-8");
            Class<?> mainClass = Class.forName(JAVA_COMPILER_CLASS, true, this.getClassLoader());
            Class[] classArray = new Class[3];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.io.PrintWriter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.io.PrintWriter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            classArray[2] = Boolean.TYPE;
            Constructor<?> constructor = mainClass.getConstructor(classArray);
            this.compiler = constructor.newInstance(new PrintWriter(osw), new PrintWriter(esw), new Boolean(true));
        }
        if (this.compileMethod == null) {
            Class<?> mainClass = this.compiler.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("[Ljava.lang.String;");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            this.compileMethod = mainClass.getDeclaredMethod(JAVA_COMPILE_METHOD, classArray);
        }
    }

    public static String getClassPath() {
        if (classPath == null) {
            StringBuffer classPathBuffer = new StringBuffer();
            try {
                JDTCompiler.addClassPathForPlugin(classPathBuffer, "org.eclipse.tptp.platform.models");
            }
            catch (Exception exception) {}
            try {
                JDTCompiler.addClassPathForPlugin(classPathBuffer, "org.eclipse.tptp.platform.logging.events");
            }
            catch (Exception exception) {}
            try {
                JDTCompiler.addClassPathForPlugin(classPathBuffer, "org.eclipse.emf.common");
            }
            catch (Exception exception) {}
            try {
                JDTCompiler.addClassPathForPlugin(classPathBuffer, "org.eclipse.emf.ecore");
            }
            catch (Exception exception) {}
            if (classPathBuffer.length() > 0) {
                classPath = classPathBuffer.toString().replace('/', File.separatorChar).replace('\\', File.separatorChar);
            }
        }
        return classPath;
    }

    public static void addClassPathForPlugin(StringBuffer classPathBuffer, String pluginID) throws Exception {
        List l = JDTCompiler.getClasspathPathsFromPlugins(pluginID);
        if (l == null) {
            return;
        }
        Iterator iterator = l.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            classPathBuffer.append(name);
            classPathBuffer.append(pathSeparator);
        }
    }

    private static List getClasspathPathsFromPlugins(String pluginID) {
        try {
            return EclipseUtils.getClasspathPathsFromPlugins(pluginID);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public Class generateClass(byte[] bytes) throws ClassNotFoundException, CodeGenerationError {
        return this.getClassLoader().defineClass(bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setVerbose(boolean verboseOutput) {
        JDTCompiler.verboseOutput = verboseOutput;
    }

    protected MyClassLoader getClassLoader() {
        if (classLoader == null) {
            classLoader = new MyClassLoader(this.getClass().getClassLoader());
        }
        return classLoader;
    }

    class MyClassLoader
    extends ClassLoader {
        byte[] bArr;

        MyClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class defineClass(byte[] arr) {
            this.bArr = arr;
            return super.defineClass(null, arr, 0, arr.length);
        }

        public byte[] getBytes() {
            return this.bArr;
        }
    }
}

