/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.fastxpath.emf;

import java.lang.reflect.Method;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.tptp.platform.provisional.fastxpath.binding.ClassMapping;
import org.eclipse.tptp.platform.provisional.fastxpath.binding.ReflectionHelper;

public class EMFReflectionHelper
implements ReflectionHelper {
    private ClassMapping classMapping;

    public EMFReflectionHelper(ClassMapping classMapping) {
        this.classMapping = classMapping;
    }

    public Object[] getAttribute(Object obj, String name) {
        EStructuralFeature struct = this.getStructuralFeature(obj, name);
        if (struct == null) {
            return this.convertToObjectArray(this.getReflectionValue(obj, name));
        }
        if (this.isAttribute(struct)) {
            return this.convertToObjectArray(((EObject)obj).eGet(struct));
        }
        return new Object[0];
    }

    public Object[] getElement(Object obj, String name) {
        EStructuralFeature struct = this.getStructuralFeature(obj, name);
        if (struct == null) {
            return null;
        }
        if (this.isElement(struct)) {
            return this.convertToObjectArray(((EObject)obj).eGet(struct));
        }
        return new Object[0];
    }

    public Object[] get(Object obj, String name) {
        EStructuralFeature struct = this.getStructuralFeature(obj, name);
        if (struct == null) {
            return null;
        }
        return this.convertToObjectArray(((EObject)obj).eGet(struct));
    }

    public String[] getAttributes() {
        return this.resolveNamesList(this.classMapping.getAttributes());
    }

    public String[] getElements() {
        return this.resolveNamesList(this.classMapping.getElements());
    }

    public boolean isSet(Object obj, String name) {
        boolean hasDefault;
        EStructuralFeature struct = this.getStructuralFeature(obj, name);
        if (struct == null) {
            return this.getReflectionValue(obj, name) != null;
        }
        boolean isSet = ((EObject)obj).eIsSet(struct);
        boolean bl = hasDefault = struct.getDefaultValueLiteral() != null;
        return isSet || hasDefault;
    }

    private Object getReflectionValue(Object obj, String name) {
        Method meth;
        Object value = null;
        String methodName = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
        try {
            meth = obj.getClass().getDeclaredMethod(methodName, null);
            value = meth.invoke(obj, null);
        }
        catch (Exception exception) {}
        if (value == null) {
            try {
                methodName = methodName.replaceFirst("get", "is");
                meth = obj.getClass().getDeclaredMethod(methodName, null);
                value = meth.invoke(obj, null);
            }
            catch (Exception exception) {}
        }
        return value;
    }

    private EStructuralFeature getStructuralFeature(Object obj, String name) {
        EStructuralFeature struct = (EStructuralFeature)this.classMapping.get(name);
        return struct;
    }

    private boolean isAttribute(EStructuralFeature struct) {
        try {
            return this.typeCheck(struct, "attribute");
        }
        catch (Exception exception) {
            return struct instanceof EAttribute;
        }
    }

    private boolean isElement(EStructuralFeature struct) {
        try {
            return this.typeCheck(struct, "element");
        }
        catch (Exception exception) {
            return struct instanceof EReference;
        }
    }

    private boolean typeCheck(EStructuralFeature struct, String kindName) throws Exception {
        EList annotations = struct.getEAnnotations();
        EAnnotation annotation = (EAnnotation)annotations.get(0);
        String kind = (String)annotation.getDetails().get((Object)"kind");
        return kind.equals(kindName);
    }

    private Object[] convertToObjectArray(Object obj) {
        if (obj instanceof EList) {
            EList list = (EList)obj;
            return list.toArray();
        }
        if (obj == null) {
            return new Object[0];
        }
        return new Object[]{obj};
    }

    private String[] resolveNamesList(Set nameList) {
        Object[] objArr = nameList.toArray();
        String[] nameArr = new String[objArr.length];
        int i = 0;
        while (i < nameArr.length) {
            nameArr[i] = (String)objArr[i];
            ++i;
        }
        return nameArr;
    }
}

