/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.fastxpath.utils;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;

public class EclipseUtils {
    public static List getClasspathPathsFromPlugins(String pluginID) throws Exception {
        ArrayList<String> result;
        block19: {
            ManifestElement[] elements;
            result = new ArrayList<String>();
            Bundle bundle = Platform.getBundle((String)pluginID);
            String requires = (String)bundle.getHeaders().get("Bundle-ClassPath");
            if (requires == null) {
                requires = ".";
            }
            if ((elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)requires)) == null) break block19;
            int i = 0;
            while (i < elements.length) {
                String resolvedURLString;
                URL resolvedURL;
                ManifestElement element = elements[i];
                String value = element.getValue();
                if (".".equals(value)) {
                    value = "/";
                }
                URL url = bundle.getEntry(value);
                if (url != null) {
                    resolvedURL = FileLocator.resolve((URL)url);
                    resolvedURLString = resolvedURL.toString();
                } else {
                    url = bundle.getEntry("/");
                    resolvedURL = new URL(FileLocator.resolve((URL)url) + value);
                    resolvedURLString = resolvedURL.toString();
                }
                if (url != null) {
                    if (resolvedURLString.endsWith("!/")) {
                        resolvedURLString = resolvedURL.getFile();
                        resolvedURLString = resolvedURLString.substring(0, resolvedURLString.length() - "!/".length());
                    }
                    String path = null;
                    if (resolvedURLString.startsWith("file:/")) {
                        path = resolvedURLString.substring("file:/".length());
                    } else if (resolvedURLString.startsWith("file:")) {
                        path = resolvedURLString.substring("file:".length());
                    }
                    if (path != null) {
                        if (new File(path = path.replace('/', File.separatorChar).replace('\\', File.separatorChar)).exists()) {
                            result.add(path);
                        } else if (!result.contains(String.valueOf(path = path.substring(0, path.lastIndexOf(File.separator))) + File.separator + "bin")) {
                            result.add(String.valueOf(path) + File.separator + "bin");
                        }
                    } else {
                        result.add(FileLocator.toFileURL((URL)url).getFile());
                    }
                }
                ++i;
            }
        }
        return result;
    }
}

