/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.jre14.fastxpath;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.apache.xpath.Expression;
import org.eclipse.tptp.platform.provisional.fastxpath.IExpression;
import org.eclipse.tptp.platform.provisional.jre14.fastxpath.EExpression;

public class EExpressionFactory {
    public static final EExpressionFactory INSTANCE = new EExpressionFactory();
    private static HashMap nameMap = new HashMap();

    private EExpressionFactory() {
    }

    public IExpression createEExprNode(Expression delegateExpression) {
        if (delegateExpression == null) {
            return null;
        }
        String delegateExpressionClassName = delegateExpression.getClass().getName();
        IExpression eExpression = (IExpression)nameMap.get(delegateExpressionClassName);
        if (eExpression == null) {
            String fastXPathExpressionClassName = this.getFastXPathExpressionClassName(delegateExpressionClassName);
            try {
                Class<?> cls = Class.forName(fastXPathExpressionClassName, false, this.getClass().getClassLoader());
                Constructor<?> ctor = cls.getConstructor(delegateExpression.getClass());
                eExpression = (IExpression)ctor.newInstance(new Object[1]);
                nameMap.put(delegateExpressionClassName, eExpression);
            }
            catch (Exception exception) {}
        }
        return ((EExpression)eExpression).instance(delegateExpression);
    }

    private String getFastXPathExpressionClassName(String expressionClassName) {
        StringBuffer sb = new StringBuffer("org.eclipse.tptp.platform.provisional.jre14.");
        int lastIndexOfDOT = expressionClassName.lastIndexOf(".");
        sb.append("fast");
        sb.append(expressionClassName.substring(expressionClassName.indexOf("xpath"), lastIndexOfDOT));
        sb.append(".E");
        sb.append(expressionClassName.substring(lastIndexOfDOT + 1));
        return sb.toString();
    }
}

