/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.sun50.fastxpath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.eclipse.tptp.platform.provisional.fastxpath.ExpressionEvaluationException;
import org.eclipse.tptp.platform.provisional.fastxpath.FastXPathAPI;
import org.eclipse.tptp.platform.provisional.fastxpath.FastXPathContext;
import org.eclipse.tptp.platform.provisional.fastxpath.FastXPathContextFactory;
import org.eclipse.tptp.platform.provisional.fastxpath.IFastXPathEngine;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CodeGenerationError;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompiledExpressionEvaluator;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompilerHelper;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompilerNotAvailableException;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompilerPostProcessor;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.FastXPathClassGenerator;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.ICompilerContext;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.ICompilerHelper;
import org.eclipse.tptp.platform.provisional.fastxpath.utils.StrTools;
import org.eclipse.tptp.platform.provisional.sun50.fastxpath.EXPath;
import org.eclipse.tptp.platform.provisional.sun50.fastxpath.compiler.CompilerContext;

public class FastXPathEngine
implements IFastXPathEngine {
    private static final String CANNOT_GENERATE_CODE_FOR_EXPRESSION__ = "Cannot generate code for expression: ";
    private FastXPathContextFactory fastXPathContextFactory;
    private HashMap knownExpressions = new HashMap();
    private Properties registeredVariables = new Properties();
    private HashMap registeredExtensionFunctionClass = new HashMap();
    private int compilerState;
    private ICompilerHelper currentHelper;
    private FastXPathClassGenerator compiler;
    private static boolean debug = false;
    private static final String FXP_DEBUG = "FXP_DEBUG";

    public FastXPathEngine() {
    }

    public FastXPathEngine(FastXPathContextFactory fastXPathContextFactory) {
        this.setFastXPathContextFactory(fastXPathContextFactory);
    }

    public FastXPathEngine(FastXPathContextFactory fastXPathContextFactory, Object object) {
        this(fastXPathContextFactory);
    }

    public Object[] selectNodes(String string, Object object) throws TransformerException, ExpressionEvaluationException {
        EXPath eXPath = (EXPath)this.getExpression(string);
        FastXPathContext fastXPathContext = this.fastXPathContextFactory.newContext(object, this);
        fastXPathContext.setEngine(this);
        return eXPath.execute(fastXPathContext);
    }

    public Object eval(String string, Object object) throws TransformerException, ExpressionEvaluationException {
        Object[] objectArray = this.selectNodes(string, object);
        if (objectArray.length > 0) {
            return objectArray[0];
        }
        return null;
    }

    public Object evalCompiled(CompiledExpressionEvaluator compiledExpressionEvaluator, Object object) throws ExpressionEvaluationException {
        return compiledExpressionEvaluator.eval(object, this);
    }

    public synchronized CompiledExpressionEvaluator compile(String string, Object object, ICompilerHelper iCompilerHelper) throws TransformerException, CodeGenerationError, CompilerNotAvailableException {
        return this.compile(string, object, false, null, null, null, iCompilerHelper);
    }

    public synchronized CompiledExpressionEvaluator compile(String string, Object object, boolean bl, FastXPathContext fastXPathContext, ICompilerContext iCompilerContext, CompilerPostProcessor compilerPostProcessor, ICompilerHelper iCompilerHelper) throws TransformerException, CodeGenerationError, CompilerNotAvailableException {
        CompiledExpressionEvaluator compiledExpressionEvaluator;
        String string2 = null;
        if (this.compilerState == 0) {
            try {
                if (this.currentHelper == null) {
                    this.currentHelper = new CompilerHelper(object.getClass());
                }
                this.currentHelper.initCompiler();
            }
            catch (CompilerNotAvailableException compilerNotAvailableException) {
                this.compilerState = -1;
                throw compilerNotAvailableException;
            }
        }
        if (this.compilerState == -1) {
            throw new CompilerNotAvailableException("Error initializing compiler");
        }
        if (bl) {
            try {
                this.eval(string, object);
            }
            catch (ExpressionEvaluationException expressionEvaluationException) {
                // empty catch block
            }
        }
        fastXPathContext = fastXPathContext == null ? this.fastXPathContextFactory.newContext(object, this) : fastXPathContext;
        iCompilerContext = iCompilerContext == null ? new CompilerContext(object, fastXPathContext, this) : iCompilerContext.setRuntimeContext(fastXPathContext, object);
        EXPath eXPath = (EXPath)this.getExpression(string);
        eXPath.getEExpression().compile(iCompilerContext);
        compilerPostProcessor = compilerPostProcessor == null ? new CompilerPostProcessor(iCompilerContext.getSb(), fastXPathContext) : compilerPostProcessor.setSb(iCompilerContext.getSb()).setFastXPathContext(fastXPathContext);
        string2 = compilerPostProcessor.postCompileProcess();
        string2 = StrTools.escape(string2);
        if (FastXPathAPI.debug) {
            System.out.println("==== " + string + " =====\n" + string2);
        }
        if (iCompilerHelper == null) {
            this.currentHelper = iCompilerHelper = new CompilerHelper(object.getClass());
            iCompilerHelper.initCompiler();
        }
        if ((compiledExpressionEvaluator = iCompilerHelper.getCompiledExpressionEvaluator(string2, string)) == null) {
            throw new CodeGenerationError(CANNOT_GENERATE_CODE_FOR_EXPRESSION__ + string);
        }
        return compiledExpressionEvaluator;
    }

    public char[] getExpressionJavaSource(String string, Object object, boolean bl, FastXPathContext fastXPathContext, ICompilerContext iCompilerContext, CompilerPostProcessor compilerPostProcessor, ICompilerHelper iCompilerHelper) throws TransformerException, CodeGenerationError, CompilerNotAvailableException {
        String string2 = null;
        if (bl) {
            try {
                this.eval(string, object);
            }
            catch (ExpressionEvaluationException expressionEvaluationException) {
                // empty catch block
            }
        }
        fastXPathContext = fastXPathContext == null ? this.fastXPathContextFactory.newContext(object, this) : fastXPathContext;
        iCompilerContext = iCompilerContext == null ? new CompilerContext(object, fastXPathContext, this) : iCompilerContext.setRuntimeContext(fastXPathContext, object);
        EXPath eXPath = (EXPath)this.getExpression(string);
        eXPath.getEExpression().compile(iCompilerContext);
        compilerPostProcessor = compilerPostProcessor == null ? new CompilerPostProcessor(iCompilerContext.getSb(), fastXPathContext) : compilerPostProcessor.setSb(iCompilerContext.getSb()).setFastXPathContext(fastXPathContext);
        string2 = compilerPostProcessor.postCompileProcess();
        string2 = StrTools.escape(string2);
        if (iCompilerHelper == null) {
            if (this.currentHelper != null) {
                iCompilerHelper = this.currentHelper;
            } else {
                this.currentHelper = iCompilerHelper = new CompilerHelper(object.getClass());
            }
        }
        iCompilerHelper.buildCompiledExpression(string2, string, false);
        return iCompilerHelper.getJavaSource();
    }

    public synchronized void batchCompile(Object object, List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        String string2 = null;
        for (int i = 0; i < list.size(); ++i) {
            FastXPathContext fastXPathContext = this.fastXPathContextFactory.newContext(object, this);
            CompilerContext compilerContext = new CompilerContext(object, fastXPathContext, this);
            string2 = (String)list.get(i);
            EXPath eXPath = null;
            try {
                eXPath = (EXPath)this.getExpression(string2);
                eXPath.getEExpression().compile(compilerContext);
            }
            catch (TransformerException transformerException) {
            }
            catch (CodeGenerationError codeGenerationError) {
                // empty catch block
            }
            CompilerPostProcessor compilerPostProcessor = new CompilerPostProcessor(compilerContext.getSb(), fastXPathContext);
            string = compilerPostProcessor.postCompileProcess();
            string = StrTools.escape(string);
            arrayList.add(string);
            string = null;
        }
        try {
            this.currentHelper = new CompilerHelper(object.getClass());
            ((CompilerHelper)this.currentHelper).batchCompile(arrayList, list);
        }
        catch (Error error) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized List batchGetJavaSource(Object object, List list, boolean bl, FastXPathContext fastXPathContext, ICompilerContext iCompilerContext, CompilerPostProcessor compilerPostProcessor, ICompilerHelper iCompilerHelper) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        String string2 = null;
        for (int i = 0; i < list.size(); ++i) {
            string2 = (String)list.get(i);
            fastXPathContext = this.fastXPathContextFactory.newContext(object, this);
            iCompilerContext = new CompilerContext(object, fastXPathContext, this);
            EXPath eXPath = null;
            try {
                eXPath = (EXPath)this.getExpression(string2);
                eXPath.getEExpression().compile(iCompilerContext);
            }
            catch (TransformerException transformerException) {
            }
            catch (CodeGenerationError codeGenerationError) {
                // empty catch block
            }
            if (compilerPostProcessor == null) {
                compilerPostProcessor = new CompilerPostProcessor(iCompilerContext.getSb(), fastXPathContext);
            } else {
                compilerPostProcessor.setSb(iCompilerContext.getSb());
                compilerPostProcessor.setFastXPathContext(fastXPathContext);
            }
            string = compilerPostProcessor.postCompileProcess();
            string = StrTools.escape(string);
            arrayList.add(string);
            string = null;
            iCompilerContext.getSb().setLength(0);
        }
        try {
            if (iCompilerHelper == null) {
                if (this.currentHelper == null) {
                    this.currentHelper = new CompilerHelper(object.getClass());
                }
                iCompilerHelper = this.currentHelper;
            }
            return ((CompilerHelper)iCompilerHelper).batchGetJavaSource(arrayList, list, compilerPostProcessor);
        }
        catch (Error error) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void resetExpressions() {
        this.knownExpressions.clear();
    }

    public void resetDeclaredVariables() {
        this.registeredVariables.clear();
    }

    public String getVariable(String string) {
        return this.registeredVariables.getProperty(string);
    }

    public void registerVariable(String string, String string2) {
        this.registeredVariables.setProperty(string, string2);
    }

    public void unRegisterVariable(String string) {
        this.registeredVariables.remove(string);
    }

    public Class getExtensionFunctionClass(String string) {
        return (Class)this.registeredExtensionFunctionClass.get(string);
    }

    public void registerFunctionClass(Class clazz, String string) {
        this.registeredExtensionFunctionClass.put(string, clazz);
    }

    public void unRegisterFunctionClass(String string) {
        this.registeredExtensionFunctionClass.remove(string);
    }

    public Object getExpression(String string) throws TransformerException {
        EXPath eXPath = (EXPath)this.knownExpressions.get(string);
        if (eXPath == null) {
            eXPath = new EXPath(string, null, null, 0, null);
            eXPath.getEExpression().linkParent(null);
            if (debug) {
                eXPath.printGraph();
            }
            this.knownExpressions.put(string, eXPath);
        }
        return eXPath;
    }

    public FastXPathContextFactory getFastXPathContextFactory() {
        return this.fastXPathContextFactory;
    }

    public void setFastXPathContextFactory(FastXPathContextFactory fastXPathContextFactory) {
        this.fastXPathContextFactory = fastXPathContextFactory;
        this.registerFunctionClass(StrTools.class, "StrTools");
    }

    public ICompilerHelper createCompilerHelper(Class clazz) {
        return new CompilerHelper(clazz);
    }

    public FastXPathClassGenerator getClassGenerator() throws CompilerNotAvailableException {
        if (this.compiler == null) {
            this.compiler = this.currentHelper != null ? this.currentHelper.getCompiler() : new CompilerHelper(null).getCompiler();
        }
        return this.compiler;
    }

    public Map getClassesAsByteArrays() {
        if (this.currentHelper != null) {
            return this.currentHelper.getClassesAsByteArrays();
        }
        return null;
    }

    static {
        debug = System.getProperty(FXP_DEBUG) != null;
    }
}

