/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.sun50.fastxpath.axes;

import com.sun.org.apache.xml.internal.dtm.Axis;
import com.sun.org.apache.xpath.internal.Expression;
import com.sun.org.apache.xpath.internal.axes.AxesWalker;
import com.sun.org.apache.xpath.internal.objects.XBoolean;
import com.sun.org.apache.xpath.internal.objects.XNumber;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.xml.transform.TransformerException;
import org.eclipse.tptp.platform.provisional.fastxpath.ExpressionEvaluationException;
import org.eclipse.tptp.platform.provisional.fastxpath.FXPObject;
import org.eclipse.tptp.platform.provisional.fastxpath.FastXPathContext;
import org.eclipse.tptp.platform.provisional.fastxpath.IExpression;
import org.eclipse.tptp.platform.provisional.fastxpath.LastToken;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CodeGenerationError;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.ICompilerContext;
import org.eclipse.tptp.platform.provisional.sun50.fastxpath.EExpressionFactory;
import org.eclipse.tptp.platform.provisional.sun50.fastxpath.axes.EPredicatedNodeTest;

public class EAxesWalker
extends EPredicatedNodeTest {
    private AxesWalker node;
    protected EAxesWalker nextEWalker;
    protected EAxesWalker prevEWalker;
    protected boolean recursiveSearch = false;
    private Object[] objArr = null;

    public IExpression instance(Expression expression) {
        return new EAxesWalker((AxesWalker)expression);
    }

    public EAxesWalker(AxesWalker axesWalker) {
        super(axesWalker);
        this.node = axesWalker;
    }

    public void printGraph(int n) {
        String string = this.indent(n);
        System.out.print(string + "AXIS = " + Axis.names[this.getAxis()]);
        super.printGraph(n);
        EAxesWalker eAxesWalker = this.getNextEWalker();
        if (eAxesWalker != null) {
            eAxesWalker.printGraph(++n);
        }
    }

    private Object[] shrink() {
        int n = 0;
        if (this.objArr == null) {
            return new Object[0];
        }
        for (int i = 0; i < this.objArr.length; ++i) {
            if (this.objArr[i] == null) continue;
            ++n;
        }
        Object[] objectArray = new Object[n];
        for (int i = this.objArr.length - 1; i >= 0; --i) {
            if (this.objArr[i] == null) continue;
            objectArray[--n] = this.objArr[i];
        }
        return objectArray;
    }

    public EAxesWalker getNextEWalker() {
        if (this.nextEWalker == null) {
            this.nextEWalker = (EAxesWalker)EExpressionFactory.INSTANCE.createEExprNode(this.getNextWalker());
        }
        return this.nextEWalker;
    }

    public EAxesWalker getPrevEWalker() {
        if (this.prevEWalker == null) {
            this.prevEWalker = (EAxesWalker)EExpressionFactory.INSTANCE.createEExprNode(this.getPrevWalker());
        }
        return this.prevEWalker;
    }

    public void setNextEWalker(EAxesWalker eAxesWalker) {
        this.nextEWalker = eAxesWalker;
        if (eAxesWalker != null) {
            this.setNextWalker(eAxesWalker.getNextWalker());
        }
    }

    public void setPrevEWalker(EAxesWalker eAxesWalker) {
        this.prevEWalker = eAxesWalker;
        this.setPrevWalker(eAxesWalker.getPrevWalker());
    }

    public boolean isRecursiveSearch() {
        return this.recursiveSearch;
    }

    public void setRecursiveSearch(boolean bl) {
        this.recursiveSearch = bl;
    }

    public void linkParent(IExpression iExpression) {
        super.linkParent(iExpression);
        EAxesWalker eAxesWalker = this.getNextEWalker();
        if (eAxesWalker != null) {
            eAxesWalker.linkParent(this);
        }
        int n = this.node.getPredicateCount();
        IExpression[] iExpressionArray = this.getEPredicates();
        for (int i = 0; i < n; ++i) {
            iExpressionArray[i].linkParent(this);
        }
    }

    public Object[] execute(FastXPathContext fastXPathContext) throws TransformerException, ExpressionEvaluationException {
        Object[] objectArray;
        String string = this.getLocalName();
        int n = this.getAxis();
        EAxesWalker eAxesWalker = this.getNextEWalker();
        if (string.equals("") && eAxesWalker != null) {
            if (n == 19) {
                objectArray = eAxesWalker.execute(fastXPathContext.createFreshContext());
            } else {
                switch (n) {
                    case 5: {
                        eAxesWalker.setRecursiveSearch(true);
                        break;
                    }
                    case 13: {
                        break;
                    }
                    default: {
                        throw new ExpressionEvaluationException();
                    }
                }
                objectArray = eAxesWalker.execute(fastXPathContext);
            }
        } else {
            this.objArr = new Object[0];
            ArrayList<Object> arrayList = null;
            int n2 = this.recursiveSearch ? 2 : 0;
            switch (n) {
                case 0: {
                    this.objArr = fastXPathContext.getAncestor(string, n2);
                    break;
                }
                case 1: {
                    this.objArr = fastXPathContext.getAncestorOrSelf(string, n2);
                    break;
                }
                case 4: {
                    this.objArr = fastXPathContext.getDescendant(string, n2);
                    break;
                }
                case 5: {
                    this.objArr = fastXPathContext.getDescendantOrSelf(string, n2);
                    break;
                }
                case 17: 
                case 18: {
                    throw new ExpressionEvaluationException("Unable to process this chain of expression nodes");
                }
                case 6: {
                    this.objArr = fastXPathContext.getFollowing(string, 2);
                    break;
                }
                case 11: {
                    this.objArr = fastXPathContext.getPreceding(string);
                    break;
                }
                case 15: {
                    this.objArr = fastXPathContext.getPrecedingSibling(string, n2);
                    break;
                }
                case 7: {
                    this.objArr = fastXPathContext.getFollowing(string, n2);
                    break;
                }
                case 12: {
                    this.objArr = fastXPathContext.getPrecedingSibling(string, n2);
                    break;
                }
                case 13: {
                    this.objArr = fastXPathContext.getSelf(string);
                    break;
                }
                case 3: {
                    if (this.recursiveSearch) {
                        this.objArr = fastXPathContext.getDescendantOrSelf(string, n2);
                        break;
                    }
                    this.objArr = fastXPathContext.getChild(string, n2);
                    break;
                }
                case 2: {
                    if (this.recursiveSearch) {
                        this.objArr = fastXPathContext.getAttribute(string, 4);
                        break;
                    }
                    this.objArr = fastXPathContext.getAttribute(string, 3);
                    break;
                }
                case 10: {
                    this.objArr = fastXPathContext.getParent();
                    break;
                }
            }
            this.processPredicates(fastXPathContext);
            if (eAxesWalker == null) {
                objectArray = this.shrink();
            } else {
                arrayList = new ArrayList<Object>();
                for (int i = 0; i < this.objArr.length; ++i) {
                    if (this.objArr[i] == null) continue;
                    Object[] objectArray2 = eAxesWalker.execute(fastXPathContext.createContext(this.objArr[i]));
                    for (int j = 0; j < objectArray2.length; ++j) {
                        arrayList.add(objectArray2[j]);
                    }
                }
                objectArray = arrayList.toArray();
            }
        }
        return objectArray;
    }

    public void compile(ICompilerContext iCompilerContext) throws CodeGenerationError {
        iCompilerContext.in(this);
        String string = this.getLocalName();
        int n = this.getAxis();
        EAxesWalker eAxesWalker = this.getNextEWalker();
        switch (n) {
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 18: {
                throw new CodeGenerationError("Cannot generate code for Axis = " + Axis.names[n]);
            }
        }
        if (string.equals("") && eAxesWalker != null) {
            eAxesWalker.compile(iCompilerContext);
        } else {
            iCompilerContext.addName(string);
            this.compilePredicates(iCompilerContext);
            if (eAxesWalker != null) {
                eAxesWalker.compile(iCompilerContext);
            }
        }
        iCompilerContext.out();
    }

    private void compilePredicates(ICompilerContext iCompilerContext) throws CodeGenerationError {
        int n = this.node.getPredicateCount();
        if (n == 0) {
            return;
        }
        iCompilerContext.enterPredicate();
        IExpression[] iExpressionArray = this.getEPredicates();
        for (int i = 0; i < n; ++i) {
            iCompilerContext.append(" ( ");
            iExpressionArray[i].compile(iCompilerContext);
            iCompilerContext.append(" ) ");
        }
        iCompilerContext.exitPredicate();
        if (iCompilerContext.getPredicateDepth() > 0 && this.getNextEWalker() != null) {
            iCompilerContext.append(" && ");
        }
    }

    private void processPredicates(FastXPathContext fastXPathContext) throws TransformerException, ExpressionEvaluationException {
        int n = this.node.getPredicateCount();
        if (n == 0) {
            return;
        }
        boolean bl = false;
        IExpression[] iExpressionArray = this.getEPredicates();
        int n2 = this.objArr.length;
        this.m_position = 0;
        while (this.m_position < n2) {
            for (int i = 0; i < n && this.objArr[this.m_position] != null; ++i) {
                Object[] objectArray = iExpressionArray[i].execute(fastXPathContext.createContext(this.objArr[this.m_position]));
                FXPObject fXPObject = (FXPObject)this.objArr[this.m_position];
                if (objectArray.length == 0 || objectArray[0] instanceof XBoolean && !((XBoolean)objectArray[0]).bool() || objectArray[0] instanceof Boolean && (Boolean)objectArray[0] == false || objectArray[0] instanceof XNumber && ((XNumber)objectArray[0]).num() != (double)fXPObject.getPosition() || objectArray[0] instanceof Integer && (Integer)objectArray[0] - 1 != this.m_position || objectArray[0] instanceof String && ((String)objectArray[0]).length() == 0) {
                    this.objArr[this.m_position] = null;
                    break;
                }
                if (!objectArray[0].equals(LastToken.INSTANCE)) continue;
                this.processLastToken();
                bl = true;
            }
            if (bl) {
                return;
            }
            ++this.m_position;
        }
    }

    private void processLastToken() {
        ArrayList<ObjectPositionTuple> arrayList = new ArrayList<ObjectPositionTuple>();
        for (int i = 0; i < this.objArr.length; ++i) {
            Object object = this.objArr[i];
            int n = 0;
            int n2 = 1;
            while (object instanceof FXPObject) {
                n += ((FXPObject)object).getPosition() * n2;
                object = ((FXPObject)object).getParent();
                n2 *= 10;
            }
            arrayList.add(new ObjectPositionTuple(this.objArr[i], n));
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                ObjectPositionTuple objectPositionTuple = (ObjectPositionTuple)object;
                ObjectPositionTuple objectPositionTuple2 = (ObjectPositionTuple)object2;
                return objectPositionTuple.position - objectPositionTuple2.position;
            }
        });
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        for (ObjectPositionTuple objectPositionTuple : arrayList) {
            nArray[n++] = objectPositionTuple.position;
        }
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add(((ObjectPositionTuple)arrayList.get((int)(arrayList.size() - 1))).obj);
        for (int i = 0; i < nArray.length - 1; ++i) {
            int n3 = nArray[i + 1] - nArray[i];
            if (n3 == 1) continue;
            arrayList2.add(((ObjectPositionTuple)arrayList.get((int)i)).obj);
        }
        this.objArr = arrayList2.toArray();
    }

    public int getAxis() {
        return this.node.getAxis();
    }

    private AxesWalker getNextWalker() {
        return this.node.getNextWalker();
    }

    private AxesWalker getPrevWalker() {
        return this.node.getPrevWalker();
    }

    private void setNextWalker(AxesWalker axesWalker) {
        this.node.setNextWalker(axesWalker);
    }

    private void setPrevWalker(AxesWalker axesWalker) {
        this.node.setPrevWalker(axesWalker);
    }

    class ObjectPositionTuple {
        Object obj;
        int position;

        public ObjectPositionTuple(Object object, int n) {
            this.obj = object;
            this.position = n;
        }
    }
}

