/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.common.api.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cosmos.dc.common.api.IDataFilterService;
import org.eclipse.cosmos.dc.common.api.IDataSinkService;
import org.eclipse.cosmos.dc.common.api.IDataSourceService;
import org.eclipse.cosmos.dc.common.api.IDataTransformService;
import org.eclipse.cosmos.dc.common.spi.IWireSource;
import org.eclipse.cosmos.dc.common.spi.IWireTarget;
import org.eclipse.cosmos.dc.mgmt.annotations.CreateManagedRelation;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedOperation;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;

public abstract class AbstractSource
implements IDataSourceService,
IWireSource {
    protected IDataSourceService _proxy;
    private static Class[] EMPTY_LIST = new Class[0];
    private static Class[] supportedTypes = EMPTY_LIST;
    private static HashMap<Class, Method> methodMap = new HashMap();
    private Method wireMethod;
    protected ArrayList<IWireTarget> targetList = new ArrayList();

    public AbstractSource(ContributionManager manager) {
        this._proxy = (IDataSourceService)manager.manage((Object)this);
    }

    public abstract boolean acceptWireTarget(IWireTarget var1) throws Exception;

    @CreateManagedRelation(type="WireTarget", namespace="http://www.eclipse.org/xmlns/cosmos/1.0")
    public void addWireTarget(IWireTarget target) throws Exception {
        if (!(target instanceof IDataFilterService || target instanceof IDataTransformService || target instanceof IDataSinkService)) {
            throw new Exception("Invalid wire target type for DataSource");
        }
        this.targetList.add(target);
        target.setWireSource(this);
    }

    public IWireTarget[] getWireTargets() {
        return this.targetList.toArray(new IWireTarget[0]);
    }

    public void setWireMethod(Method wireMethod) {
        this.wireMethod = wireMethod;
    }

    public Method getWireMethod() {
        return this.wireMethod;
    }

    public void dispatch(Object obj) {
        Object[] args = new Object[]{obj};
        for (IWireTarget target : this.targetList) {
            Method targetMethod = target.getWireMethod();
            if (targetMethod == null) continue;
            try {
                targetMethod.invoke((Object)target, args);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @ManagedOperation(namespace="http://www.eclipse.org/xmlns/cosmos/datasource/1.0")
    public abstract boolean connect() throws Exception;

    @ManagedOperation(namespace="http://www.eclipse.org/xmlns/cosmos/datasource/1.0")
    public abstract boolean run() throws Exception;

    @ManagedOperation(namespace="http://www.eclipse.org/xmlns/cosmos/datasource/1.0")
    public abstract boolean disconnect() throws Exception;

    @ManagedOperation(namespace="http://www.eclipse.org/xmlns/cosmos/datasource/1.0")
    public abstract boolean cancel() throws Exception;

    @ManagedOperation(namespace="http://www.eclipse.org/xmlns/cosmos/datasource/1.0")
    public abstract boolean pause() throws Exception;

    @ManagedOperation(namespace="http://www.eclipse.org/xmlns/cosmos/datasource/1.0")
    public abstract boolean resume() throws Exception;
}

