/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.sample.components.sink.cbe.wrapper;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class CBEUtil {
    public static SimpleDateFormat partialCIMDateFormatDashDelimiter = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH:mm:ss", Locale.ENGLISH);
    public static SimpleDateFormat partialCIMDateFormatPlusDelimiter = new SimpleDateFormat("yyyy'+'MM'+'dd'T'HH:mm:ss", Locale.ENGLISH);
    public static SimpleDateFormat partialCIMDateFormatNoDelimiter = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss", Locale.ENGLISH);

    public static synchronized double getMicrosecondsFromCIMFormat(String creationTime) throws IllegalArgumentException {
        double creationTimeInMicros = 0.0;
        int tCharIndex = creationTime.indexOf(84);
        if (tCharIndex != -1) {
            try {
                creationTimeInMicros = (double)partialCIMDateFormatDashDelimiter.parse(creationTime.substring(0, tCharIndex + 9)).getTime() * 1000.0;
            }
            catch (ParseException parseException) {
                try {
                    creationTimeInMicros = creationTime.charAt(tCharIndex - 3) == '+' ? (double)partialCIMDateFormatPlusDelimiter.parse(creationTime.substring(0, tCharIndex + 9)).getTime() * 1000.0 : (double)partialCIMDateFormatNoDelimiter.parse(creationTime.substring(0, tCharIndex + 9)).getTime() * 1000.0;
                }
                catch (ParseException parseException2) {
                    throw new IllegalArgumentException("Invalid parameter time stamp format.");
                }
            }
            try {
                creationTimeInMicros += Double.parseDouble("0.".concat(creationTime.substring(tCharIndex + 10, creationTime.endsWith("Z") ? creationTime.length() - 1 : creationTime.length() - 6))) * 1000000.0;
            }
            catch (Exception exception) {}
        } else {
            throw new IllegalArgumentException("Invalid parameter time stamp format.");
        }
        return creationTimeInMicros;
    }

    public static synchronized short getDeltaTimeZoneInMinutesFromCIMFormat(String creationTime) throws IllegalArgumentException {
        int creationTimeLength = creationTime.length();
        short timeZoneOffset = 0;
        if (creationTime.charAt(creationTimeLength - 1) != 'Z') {
            try {
                timeZoneOffset = Short.parseShort(creationTime.substring(creationTimeLength - 5, creationTimeLength - 3));
                timeZoneOffset = (short)(timeZoneOffset * 60);
                timeZoneOffset = (short)(timeZoneOffset + Short.parseShort(creationTime.substring(creationTimeLength - 2)));
                if (creationTime.charAt(creationTimeLength - 6) == '-') {
                    timeZoneOffset = (short)(timeZoneOffset * -1);
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Invalid parameter time stamp format.");
            }
        }
        return timeZoneOffset;
    }
}

